/* @TITLE "rapid.h - RAPID interface functions" */
/* Various declarations for the RAPID system. */
/* for external use only; not for use with internal.h */
/* $Id: rapid.h,v 7.1 91/05/09 19:29:51 dfk Tape2 $ */

typedef struct RAPID_Descriptor RAPIDFILE;

/* From interface.c */

extern void	 	RT_open();
extern void  	 	RT_close();
extern int  	 	RT_read();
extern int  	 	RT_write();
extern void 	 	RT_access();
extern long 	 	RT_lseek();

extern void 	 	RT_flush();
extern void 	 	RT_dump();

/* from alloc.c */
extern ANYPTR AllocGlobal();	/* safely allocate shared memory */
extern ANYPTR AllocScatterMatrix();	/* safely allocate scattered memory */
extern ANYPTR AllocLocal();	/* safely allocate local shared memory */
extern ANYPTR AllocPrivate();	/* safely allocate private memory */

/* Replacement algorithms from replace.c */
#include "replace.h"

/* Prefetch/prediction algorithms from prefetch.c */
#include "prefetch.h"

/* From init.c */
extern void InitializeRAPIDSystem();
extern void InitElogs();
