/* @TITLE "prefetch.h - RAPID prefetch/prediction algorithms" */
/* $Id: prefetch.h,v 7.1 91/05/09 19:29:51 dfk Tape2 $ */

/* From prefetch.c */
extern void RT_StartPrefetch();
extern void RT_WhatPrefetch();
extern void RT_Prefetch();
extern void RT_CancelPrefetch();

/* prediction algorithm numbers (also check PrefetchAlgCodes[] in driver.c) */
#define PFA_NONE 0
#define PFA_EXACT 1
#define PFA_OBL 2
#define PFA_IBL 3
#define PFA_PORT 4
#define PFA_ADAPT 5
#define PFA_IOBL 6
#define PFA_IPORT 7
#define PFA_IOPORT 8
#define PFA_GAPS 9
#define PFA_RGAPS 10
#define PFA_GW 11
#define PFA_SWITCH 12

/* INTERNAL ONLY: */

/* macros for accessing prediction algorithms */
#define MayBePrefetchWork(rpd) ((rpd)->prefetch.available)
#define PrefetchWorkAvailable(rpd) \
  (MayBePrefetchWork(rpd) && (*((rpd)->prefetch.checkavail))(rpd))
#define GetPrefetchWork(rpd, sectorp) \
  ((*((rpd)->prefetch.getwork))((rpd), sectorp))
#define GiveBackPrefetchWork(rpd, sector) \
  ((*((rpd)->prefetch.giveback))((rpd), sector))
#define DonePredict(rpd) \
  {if((rpd)->prefetch.donerpd) (*((rpd)->prefetch.donerpd))(rpd);}
#define NotifyPredict(rpd, sector) \
  (((rpd)->prefetch.notify)? (*((rpd)->prefetch.notify))((rpd), (sector)) \
   : FALSE)
#define LateNotifyPredict(node, rapid, private, last, length, sector) \
  ((*((rpd)->prefetch.latenotify))((node), (rapid), (private), \
							(last), (length), (sector)) )

/* from prefetch.c */
extern void RT_InitPrefetch();
extern void RT_PrefetchMistake();
extern boolean InitPredict();	/* for access by SWITCH predictor */
