/* @TITLE "synch.h - definitions for synchronization functions" */

/* $Id: synch.h,v 7.1 91/05/09 19:34:39 dfk Tape2 $ */

/* For use with synch.c functions */

typedef struct Synch_struct SYNCH;

extern SYNCH *UsMakeSynch();
extern SYNCH *MakeSynch();
extern void SetSynch();
extern void SynchronizeOut();

/* Synchronize a number of processes using variable s */
#define Synchronize(s)  				SynchronizeFull(s, NULL, 0, NULL, 0)
/* Like Synchronize, but work on (*w)(wa) while waiting */
#define SynchronizeWork(s, w, wa)		SynchronizeFull(s, w, wa, NULL, 0)
/* Like Synchronize, but do (*r)(ra) in the synchronization point */
#define SynchronizeReset(s, r, ra)		SynchronizeFull(s, NULL, 0, r, ra)
/* Like the above, but does both work and the reset */
extern void SynchronizeFull(/* s, w, wa, r, ra */);

/* extended stuff for getting statistics */
extern float SynchTotal();	/* how much total delay on synch? */
extern float SynchMax();		/* how much max delay on synch? */


/* neighbor.c functions */
extern void NeighborInit();
extern void SynchronizeNeighbor(/* worker, worker_arg */);
extern float NBSynchTotal();	/* how much total delay on synch? */
extern float NBSynchMax();	/* how much max delay on synch? */
