#ifdef CHECK
#include <sys/time.h>
#include <sys/resource.h>

extern void CheckFaults();
extern struct rusage before;	/* prior to each test (per proc) */
extern struct rusage last;	/* since last checkpoint (per proc) */
#endif

/* @SUBTITLE "CheckFaults: Look for page fault activity" */
#ifdef CHECK
void
CheckFaults(where, data, last)
	char *where;
	int data;
	struct rusage *last;
{
    struct rusage now;
    int minor, major, swap;
    
    /* Find out what our usage was like */
    getrusage(RUSAGE_SELF, &now);
    
    minor = now.ru_minflt - last->ru_minflt;
    major = now.ru_majflt - last->ru_majflt;
    swap = now.ru_nswap - last->ru_nswap;
    
    if (swap || minor || major)
	 printf("Proc %d (%s %d) had %d swaps, %d minor faults, %d major faults\n",
		   UsProc_Node, where, data, swap, minor, major);
    
    /* refetch the usage, to avoid faults fronm above printf */
    getrusage(RUSAGE_SELF, last);
}
#endif CHECK
