# BEGIN {
# For use with pickint shell script
# The shell script adds the definition of variables "to" and "from"
# and the start of the BEGIN portion of this awkfile.
# from=0 means start from before E_BEGIN
# to=0 means go to the very end.
# the intervals start and end at the SYNCHEND event
# script guarantees that from<=to or to=0
    E_BEGIN = 5;
    E_END = 6;
    E_SYNCHSTART = 2;
    E_SYNCHEND = 3;
    node = -1;
}

# New node: reset output flag
$2 != node {
    node = $2;
    interval = 0;
    if (from == 0) 
    	   output=1;
    else
    	   output=0;
}

# Turn output ON
$3 == E_BEGIN || $3 == E_SYNCHEND {
    interval++;
    if (from == interval) 
        output = 1;
}

# Output the line whenever output is true
{ if (output)
    	   print $0;
}

# Turn output OFF
$3 == E_SYNCHEND {
    if (to > 0 && interval > to)
    	   output = 0;
    next;
}

$3 == E_END {
    if (to != 0) 
        output = 0;
}

