/* @TITLE "GAPS -- Global-Access-Pattern Sequentiality" */
/* 
 * GAPS: Global-Access-Pattern Sequentiality.
 * 
 * This is a driver for the GAPS predictor. 
 *
 * usage:
 *   gaps patternfile
 * where patternfile is an 'elogdump -stpm =4 | cols 2 4 '
 * of some global pattern. That is, each line contains a pair: 
 *    node block
 *
 * Output (to stdout):
 *  Watch phase is in columns of six numbers:
 *   node        node number 
 *   block       block number
 *   n           number in context queue
 *   cutoff      cutoff block number (lowest last)
 *   samplesize  size of context after trimming recent refs
 *   usedcount   number of refs in complete zone
 *   coef        coefficient of determination, where possible
 *   sequential  y or n
 *  Continuation phase in columns of 4 numbers and a y
 *   node        node number 
 *   block       block number
 *   minlast     minimum last value
 *   maxlast     maximum last value
 *   sequential  y 
 *  Plus several messages for sequentiality failure
 *
 * David Kotz March 1990
 */

/* $Id: main.c,v 1.8 90/03/21 15:04:58 dfk Exp $ */

#include <stdio.h>
#include "dfk.h"

char *progname;

/* Functions */
extern void InitGAPS();
extern void NotifyGAPS();
extern void DoneGAPS();

/* @SUBTITLE "main program" */

main(argc, argv)
	int argc;
	char **argv;
{
    char *filename;
    FILE *pfile;
    int node, block;

    progname = argv[0];

    if (argc != 2) {
	   fprintf(stderr, "Usage: %s patternfile\n", progname);
	   exit(1);
    }

    filename = argv[1];
    pfile = fopen(filename, "r");
    if (pfile == (FILE *)NULL) {
	   fprintf(stderr, "%s: cannot open pattern file '%s'\n", 
			 progname, filename);
	   exit(2);
    }

    InitGAPS();

    while (fscanf(pfile, "%d %d\n", &node, &block) == 2)
	 NotifyGAPS(block, node);

    DoneGAPS();

    fclose(pfile);
}
