/*
 * queue - Maintain a queue of items
 * 
 * David Kotz      January 1989
 *
 * The elements on the queue are int's. 
 * The queue is of fixed size - it can overflow.
 *
 */

#include <stdio.h>
#include "dfk.h"
#include "queuestack.h"

/* typedef struct queue_s QUEUE; */ /* defined in queuestack.h */

struct queue_s {
    int length;			/* length of queue */
    int first, last;		/* begin and end of queue */
    int *queue;			/* the queue itself */
};

QUEUE *
MakeQueue(size)
	int size;				/* maximum number of elements */
{
    QUEUE *q;

    size++;				/* make room for dummy space in queue */

    q = (QUEUE *)malloc(sizeof(QUEUE));

    if (q == (QUEUE *) NULL)
	 return((QUEUE *) NULL);

    q->queue = (int *)malloc(size * sizeof(int));
    if (q->queue == (int *)NULL) {
	   free(q);
	   return((QUEUE *) NULL);
    }

    q->length = size;
    q->first = q->last = 0;

    return(q);
}

int						/* how many elements in queue */
Inqueue(q)
	QUEUE *q;
{
    return((q->last + q->length - q->first) % q->length);
}

boolean					/* TRUE if queue is empty */
Emptyqueue(q)
	QUEUE *q;
{
    return(q->first == q->last);
}

qs_error
Enqueue(q, x)
	QUEUE *q;
	int x;
{
    if ((q->last + 1) % q->length == q->first)
	 return(QS_OVERFLOW);

    q->queue[q->last] = x;
    q->last = (q->last + 1) % q->length;
    return(QS_OK);
}

qs_error
Dequeue(q, x)
	QUEUE *q;
	int *x;
{
    if (q->first == q->last)
	 return (QS_EMPTY);

    *x = q->queue[q->first];
    q->first = (q->first + 1) % q->length; 
    return(QS_OK);
}

/* nondestructively return the ith element of the queue */
/* the first (next to be dequeued) element is i=0 */
qs_error					/* QS_OK if successful */
Peekqueue(q, i, x)
	QUEUE *q;
	int i;
	int *x;
{
    if (i >= Inqueue(q))
	 return (QS_OVERFLOW);

    *x = q->queue[(q->first+i) % q->length];
    return(QS_OK);
}
