/* @TITLE "util.h: definitions for util.ca"*/
/* 
 * Definitions for functions in util.ca.
 * functions:
 *    WordCopy
 *    DMAcopy
 *    WaitDuration
 *    WaitTime
 *    
 * See also userdata.h and aux.h
 *
 * Part of 
 *           The STARFISH Parallel file-system simulator
 *      (Simulation Tool for Advanced Research in File Systems)
 *
 *                              David Kotz
 *                          Dartmouth College
 *                             Version 3.0
 *                             October 1996
 *                         dfk@cs.dartmouth.edu
 */

/* $Id: util.h,v 3.0 1996/10/18 06:05:51 dfk RELEASE3 dfk $ */

#ifndef UTIL_H
#define UTIL_H

#include "time.h"

/* Like bcopy, but for word-aligned buffers, length in words */
extern void WordCopy(void *src, void *dest, int length);

/* Like bzero, but for word-aligned buffer, length in words */
extern void WordZero(void *dest, int length);

/* suspend for a given duration of time */
extern void WaitDuration(TICS duration);

/* suspend until a given clock value is reached */
extern void WaitTime(TICS time);

#endif /* UTIL_H */
