# a nawk script
# Part of
#              The STARFISH Parallel file-system simulator
#        (Simulation Tool for Advanced Research in File Systems)
# 
#                               David Kotz
#                           Dartmouth College
#                              Version 3.0
#                              January 1996
#                          dfk@cs.dartmouth.edu
#


# input fields:
#   1      2     3       4        5             6
# Pattern CPFS IOPFS DISK_SORT RECORD_SIZE DISK_LAYOUT 
#  7              8      9    10     11         12     13
# FILE_BLOCKS BLOCK_SIZE Nio Ncomp NO_OF_DISKS total tthruput
#    14
#  trial

# output fields:
# system-name, iop, sort, tthruput

BEGIN {
    i = 0;

    patname[i++] =     "nullcommtest";
    patname[i++] =     "datacommtest";
    patname[i++] =     "memgettest";
    patname[i++] =     "copytest";
    patname[i++] =     "disktest";

    # plain patterns 
    patname[i++] =     "rrlw";
    patname[i++] =     "rrlps";
    patname[i++] =     "brlw";
    patname[i++] =     "rwlw";
    patname[i++] =     "bwlw";
    patname[i++] =     "wrlw";
    patname[i++] =     "wrlw1";
    patname[i++] =     "wwlw1";
    patname[i++] =     "wrseg";
    patname[i++] =     "wwseg";

    # Read, 1-D distributions 
    patname[i++] =     "wrn";
    patname[i++] =     "wrb";
    patname[i++] =     "wrc";

    # Read, 2-D DISTRIBUTION(NONE, ...) 
    patname[i++] =     "wrnn";
    patname[i++] =     "wrnb";
    patname[i++] =     "wrnc";

    # Read, 2-D DISTRIBUTION(BLOCK, ...) 
    patname[i++] =     "wrbn";
    patname[i++] =     "wrbb";
    patname[i++] =     "wrbc";

    # Read, 2-D DISTRIBUTION(CYCLIC, ...) 
    patname[i++] =     "wrcn";
    patname[i++] =     "wrcb";
    patname[i++] =     "wrcc";

    # Write, 1-D distributions 
    patname[i++] =     "wwn";
    patname[i++] =     "wwb";
    patname[i++] =     "wwc";

    # Write, 2-D DISTRIBUTION(NONE, ...) 
    patname[i++] =     "wwnn";
    patname[i++] =     "wwnb";
    patname[i++] =     "wwnc";

    # Write, 2-D DISTRIBUTION(BLOCK, ...) 
    patname[i++] =     "wwbn";
    patname[i++] =     "wwbb";
    patname[i++] =     "wwbc";

    # Write, 2-D DISTRIBUTION(CYCLIC, ...) 
    patname[i++] =     "wwcn";
    patname[i++] =     "wwcb";
    patname[i++] =     "wwcc";

    sortname[0] = "";
    sortname[1] = "/sort";

    i = 0;
    cpfsname[i++] = "none";
    cpfsname[i++] = "sgl";
    cpfsname[i++] = "dbl";
    cpfsname[i++] = "thrd";
    cpfsname[i++] = "dir";

    i = 0;
    iopfsname[i++] = "none";
    iopfsname[i++] = "buf";
    iopfsname[i++] = "cache";
    iopfsname[i++] = "dir";
    iopfsname[i++] = "gen";

    layout[0] = "contig";
    layout[1] = "rsectors";
    layout[2] = "rtracks";
}

######################################
# for every input line
{
# system name is pattern.recordsize.fileblocks.layout
    sys = patname[$1] "." $5 "." $7 "." layout[$6];
    newfile = "data." sys;
    if (file != newfile) close(file);
    file = newfile;

    y = $13;

    print $14, iopfsname[$3] sortname[$4], y > file;

# replicate the 'sort' cases from the nosort cases, in some places
#    if (sortname[$4] == "nosort" && layout[$6] == "contig")
#	print $14, iopfsname[$3] "/sort", y > file;
}
