# a nawk script
# goes with csh script 'compare' 


# Part of
#              The STARFISH Parallel file-system simulator
#        (Simulation Tool for Advanced Research in File Systems)
# 
#                               David Kotz
#                           Dartmouth College
#                              Version 3.0
#                              January 1996
#                          dfk@cs.dartmouth.edu
#

# expect definition of variable 'ngroups' on command line
# should be 1 or 2
#  1: we only have the 8 or 8192 columns
#  2: we have both 8 and 8192 columns

# INPUT COLUMNS ARE:
# 1 pat
#
# 2 8 A       MB/s        if ngroups==1, this might have 8192-byte records
# 3 8 B       MB/s        if ngroups==1, this might have 8192-byte records
# 4 8 B/A     ratio       if ngroups==1, this might have 8192-byte records
# 5 8 sig     yes/no	  if ngroups==1, this might have 8192-byte records
#
# 6 8192 A    MB/s        or empty if ngroups==1
# 7 8192 B    MB/s        or empty if ngroups==1
# 8 8192 B/A  ratio       or empty if ngroups==1
# 8 8192 sig  yes/no	  or empty if ngroups==1
#

BEGIN {
  sigformat["no"] = "\\em";
  sigformat["yes"] = "";

  if (ngroups==2) {
    print "\\begin{tabular}{l|rrr||rrr|}";
    printf " & \\multicolumn{3}{c||}{8-byte records} & ";
    printf "\\multicolumn{3}{c|}{8192-byte records} \\\\\n";
    
    printf "Pattern & ";
    printf "A & B & B/A & ";
    printf "A & B & B/A  \\\\\n";
    print "\\hline";
  } else {
    print "\\begin{tabular}{l|rrr|}";
    
    printf "Pattern & ";
    printf "A & B & B/A  \\\\\n";
    print "\\hline";
  }
}

# draw an hline before wrn and wwn
$1 == "wwn" || $1 == "wrn" {
  print "\\hline";
}

# one row for each input line
{
  printf "\\%s/ & ", $1; # pat

  if ($2 == "x") {
    printf "    - &     - &     - ";
  } else {
    printf "%5.1f & %5.1f & {%s %6.2f} ", $2, $3, sigformat[$5], $4;
  }

  if (ngroups > 1) {
    if ($5 == "x") {
      printf "&     - &    -  &     - ";
    } else {
      printf "& %5.1f & %5.1f & {%s %6.2f} ", $6, $7, sigformat[$9], $8;
    }
  }
  printf "\\\\\n";
}
  
END {
    print "\\hline"
    print "\\end{tabular}"
}
