/* @TITLE "proteus.h: Basic definitions for Proteus programs"*/
/* 
 * This file should be included by all files. 
 * includes:
 *    basic proteus stuff
 * macros:
 *    SPIN_UNTIL
 *    INVARIANT2
 *    INVARIANT3
 *    INVARIANT4
 *
 * Part of 
 *           The STARFISH Parallel file-system simulator
 *      (Simulation Tool for Advanced Research in File Systems)
 *
 *                              David Kotz
 *                          Dartmouth College
 *                             Version 3.0
 *                             October 1996
 *                         dfk@cs.dartmouth.edu
 */

/* $Id: proteus.h,v 3.0 1996/10/18 06:05:51 dfk RELEASE3 dfk $ */

#ifndef PROTEUS_H
#define PROTEUS_H

#include "user.h"

/* Manually check for quantum expiration.
 *   This is useful in .c files, especially in loops, where 
 * we are using AddTime() a lot but should really check now and
 * whether the quantum has expired.  PassControl() is not appropriate
 * for that purpose because 1) it adds time, and 2) it's slow, and 3) it
 * switches when we may not really need to switch.
 *   Note that the code is just like that inserted by augment, including
 * a bizarre save/retrieve of $31 (return value), which seems not to
 * matter (except perhaps for debugging). 
 */
extern void SimQuantum(void);
#define QuantumCheck() \
	if (cycles_ <= 0) {   /* if quantum expired */ \
	    asm("sw	$31, -4($sp)");	/* save return address */ \
	    SimQuantum(); \
	    asm("lw	$31, -4($sp)");	/* restore return address */ \
    	}

/* get size in words, rounding up */
#define wordsizeof(x) ((sizeof(x) + sizeof(Word) - 1) / sizeof(Word))

/**************************************************************************/
/* spin on condition */

#define SPIN_UNTIL(x)  while (!(x)) { PassControl(); }


/**************************************************************************/
/* invariant definitions */

#define CHECK_INVARIANTS

#ifdef CHECK_INVARIANTS
#define INVARIANT2(x, y) \
  { CYCLE_COUNTING_OFF; \
    if (!(x)) { \
       fprintf(stderr, "INVARIANT false: processor %d in \"%s\", line %d\n", \
	       CURR_PROCESSOR, __FILE__, __LINE__); \
       fatal(y); \
    } \
    CYCLE_COUNTING_ON; }

#define INVARIANT3(x, y, z) \
  { CYCLE_COUNTING_OFF; \
    if (!(x)) { \
      fprintf(stderr, "INVARIANT false processor %d in \"%s\", line %d\n", \
	      CURR_PROCESSOR, __FILE__, __LINE__); \
      fatal((y), (z)); \
    } \
    CYCLE_COUNTING_ON; }

#define INVARIANT4(x, y, z, w) \
  { CYCLE_COUNTING_OFF; \
    if (!(x)) { \
       fprintf(stderr, "INVARIANT false: processor %d in \"%s\", line %d\n", \
	       CURR_PROCESSOR, __FILE__, __LINE__); \
       fatal((y), (z), (w)); \
    } \
    CYCLE_COUNTING_ON; }

#else
#define INVARIANT2(x, y)
#define INVARIANT3(x, y, z)
#define INVARIANT4(x, y, z, w)
#endif

#endif /* PROTEUS_H */
