/* @TITLE "pool.h: pool data structure"*/
/* 
 * pool: a pool is a collection of undistinguishable items, 
 * supporting Add and RemoveAny as basic operations.  This is useful
 * for maintaining collections of free items, where a queue's
 * semantics are too strong.   We implement the pool here as a stack,
 * just because it is fast and convenient.
 *
 * Part of 
 *           The STARFISH Parallel file-system simulator
 *      (Simulation Tool for Advanced Research in File Systems)
 *
 *                              David Kotz
 *                          Dartmouth College
 *                             Version 3.0
 *                             October 1996
 *                         dfk@cs.dartmouth.edu
 */

/* $Id: pool.h,v 3.0 1996/10/18 06:05:51 dfk RELEASE3 dfk $ */

#ifndef POOL_H
#define POOL_H

typedef struct pool_s POOL;   /* Pool handle */
typedef void *PoolItem;	      /* a pool item is any pointer */

extern POOL *MakePool(int size, char *debugname); /* make a new pool */
extern void AddToPool(POOL *pool, PoolItem item); /* add item to pool */
extern void RemoveFromPool(POOL *pool, PoolItem *itemp); /* take any item */
extern int InPool(POOL *p);   /* how many in pool right now */
extern boolean EmptyPool(POOL *p); /* TRUE if pool is empty */
extern void FreePool(POOL *p); /* destroy a pool */

#endif POOL_H
