/* @TITLE "iopfs.h: file system functions on the I/O proc"*/
/* 
 * I/O functions supported by the I/O proc, defined in iopfs*.ca
 * functions:
 *    IOPread
 *    IOPblockread
 *    IOPwrite
 *    IOPblockwrite
 *
 * Part of 
 *           The STARFISH Parallel file-system simulator
 *      (Simulation Tool for Advanced Research in File Systems)
 *
 *                              David Kotz
 *                          Dartmouth College
 *                             Version 3.0
 *                             October 1996
 *                         dfk@cs.dartmouth.edu
 */

/* $Id: iopfs.h,v 3.0 1996/10/18 06:05:51 dfk RELEASE3 dfk $ */
/* based on ionode.h,v 1.4 92/12/13 */

#ifndef IOPFS_H
#define IOPFS_H

#include "dmcache.h"
#include "protocol.h"
#include "diskdriver.h"
#include "iopfs.param"

/* IOPtop() and IOWait() are called only by Worker, and are thus in worker.h */

/* Initialize the IOP file system; called by all IO procs.
 *   maxRequestSize should be filled in with the word size of 
 * largest possible request.
 */
extern void IOPinit(int IOPnum, boolean newfile, int *maxRequests, int *maxRequestSize);

/* shut down the IOP file system; called by all IO procs */
extern void IOPdone(int IOPnum);

/* Basic I/O proc operations. */
/* shut down the IOP file system; called by all IO procs */
void IOPflush(struct MIOPdirect *request, FuncPtr freereq, void *freearg);

/* read arbitrary offset and size, directly to buffer */
extern void IOPread(struct MIOPread *request, 
		    FuncPtr freereq, void *freearg);
/* read block directly into MBUFFER */
extern void IOPblockread(struct MIOPblockread *request, 
			 FuncPtr freereq, void *freearg);

/* write arbitrary offset and size; optional reply */
extern void IOPwrite(struct MIOPwrite *request, 
		     FuncPtr freereq, void *freearg);
/* write arbitrary offset and size, USING MEMGET for transfer; optional reply*/
extern void IOPwrite_memget(struct MIOPwrite_memget *request, 
			    FuncPtr freereq, void *freearg);
/* write an MBUFFER; optional reply */
extern void IOPblockwrite(MBUFFER *request, 
			  FuncPtr freereq, void *freearg);

/* These functions supported only by CP_DIRECT, and IOP_GENERAL */
/* for others, there are stubs in iopfs-direct-stubs.ca */

/* read whole file for all procs */
extern void IOPread_lw(struct MIOPdirect *request, 
		       FuncPtr freereq, void *freearg);

/* write whole file */
extern void IOPwrite_lw1(struct MIOPdirect *request, 
			 FuncPtr freereq, void *freearg);

/* read whole file in seg pattern */
extern void IOPread_seg(struct MIOPdirect *request, 
			FuncPtr freereq, void *freearg);
/* write whole file in seg pattern */
extern void IOPwrite_seg(struct MIOPdirect *request, 
			 FuncPtr freereq, void *freearg);

/* read whole file in some generic pattern */
extern void IOPread_gen(struct MIOPgeneral *request, 
			FuncPtr freereq, void *freearg);
/* write whole file in some generic pattern */
extern void IOPwrite_gen(struct MIOPgeneral *request, 
			 FuncPtr freereq, void *freearg);

#endif /* IOPFS_H */
