/* @TITLE "dmcache.h: Top-level include file for dmcache"*/
/* 
 * This file should be included by all files. It defines:
 * includes:
 *    all basic dfk stuff
 *    all basic proteus stuff
 *    all basic DMCACHE parameters, compile- and run-time
 * macros:
 *    IOP2PROC
 *    CP2PROC
 *
 * Part of 
 *           The STARFISH Parallel file-system simulator
 *      (Simulation Tool for Advanced Research in File Systems)
 *
 *                              David Kotz
 *                          Dartmouth College
 *                             Version 3.0
 *                             October 1996
 *                         dfk@cs.dartmouth.edu
 */

/* $Id: dmcache.h,v 3.0 1996/10/18 06:05:51 dfk RELEASE3 dfk $ */

#ifndef DMCACHE_H
#define DMCACHE_H

#include <stdio.h>
#include <stdlib.h>
#include "dfk.h"
#include "proteus.h"
#include "dmcache.param"

/* For private functions (that is, local to a .c file). */
/* #define PRIVATE static */  /* the proper definition */
#define PRIVATE		      /* makes debugging easier */

/* GLOBAL DEFINITIONS */
/* convert an IO proc number into a proc number */
#define IOP2PROC(IOPnum) ((IOPnum)+1)
/* convert a compute proc number into a proc number */
#define CP2PROC(CPnum) ((CPnum)+Nio+1)

/* reverse of IOP2PROC: convert proc number into IO proc number */
#define PROC2IOP(proc) ((proc)-1)
/* reverse of CP2PROC: convert proc number into compute proc number */
#define PROC2CP(proc) ((proc)-Nio-1)

#define FILENAMELEN 200		/* length of file names */

/* We round up to integral # flits >= 1 */
/* adds 4 bytes for the overhead (dest(1), length(2), type/priority(1)) */
#define BYTES2FLITS(bytes) (((bytes) + 4 + BYTESperFLIT - 1) / BYTESperFLIT)
#define WORDS2FLITS(words) BYTES2FLITS((words) * sizeof(Word))

/* GLOBAL PARAMETERS */
/*
 * These parameters are declared in the driver.c file.
 * Not all run-time parameters are declared here.
 */
extern int Nio, Ncomp;	      /* number of IOPs and CPs */

#endif /* DMCACHE_H */
