/* @TITLE "diskreq.h: dual-queue data structure"*/
/* 
 * diskreq: a disk-request structure, to be shared by 
 * DiskDriver and Diskq modules only.
 *
 * Part of 
 *           The STARFISH Parallel file-system simulator
 *      (Simulation Tool for Advanced Research in File Systems)
 *
 *                              David Kotz
 *                          Dartmouth College
 *                             Version 3.0
 *                             October 1996
 *                         dfk@cs.dartmouth.edu
 */

/* $Id: diskreq.h,v 3.0 1996/10/18 06:05:51 dfk RELEASE3 dfk $ */

#ifndef DISKREQ_H
#define DISKREQ_H

#include "dmcache.h"
#include "diskdriver.h"	      /* for typedef */

/**** TYPES ****/

/* The kind of disk requests that can be on the request queue */
typedef enum {
    DISK_READ, DISK_WRITE, DISK_PREREAD, DISK_SYNC, DISK_END, DISK_DIE
} RequestType;

/* Representing one of these things:
 *    a disk request, on the request queue 
 *    a buffer, on the buffer queue
 *    a prerequest, on the prerequest queue
 */
/* typedef struct disk_request DiskRequest; */  /* is in diskdriver.h */
struct disk_request {
    RequestType type;	      /* what kind of request? */
    int disk;		      /* which disk is involved */
    ulong diskblock;	      /* which (logical) diskblock is involved */
    UserData buffer;	      /* where the data goes (comes from) */
    boolean done;	      /* is the transfer complete? */
    boolean success;	      /* for ReadNext; did we get anything? */
    boolean rewrite;	      /* oops, write it again */
    int waiting_tid;	      /* what thread is waiting, if any */
    DiskRequest *next;	      /* used by DISKQ */
};

#endif DISKREQ_H
