/* @TITLE "disk.h: Definitions about the disk"*/
/* 
 * Some basic parameters about the disk, derived from the even more basic
 * stuff in disk.param.  I don't let config do these derivations because
 * I don't trust its math.
 *
 * Part of 
 *           The STARFISH Parallel file-system simulator
 *      (Simulation Tool for Advanced Research in File Systems)
 *
 *                              David Kotz
 *                          Dartmouth College
 *                             Version 3.0
 *                             October 1996
 *                         dfk@cs.dartmouth.edu
 */

/* $Id: disk.h,v 3.0 1996/10/18 06:05:51 dfk RELEASE3 dfk $ */

#ifndef DISK_H
#define DISK_H

#include "disk.param"

#define CACHE_BLOCK_SIZE  BLOCK_SIZE
#define BLOCK_SIZE_MASK (BLOCK_SIZE-1)

/* a block number that does not represent an actual block */
/* (added very recently and thus not used in many places it could be) */
#define NOTABLOCK  ((ulong) -1) 

#endif /* DISK_H */
