/* @TITLE "condition.h: condition-variable data structure"*/
/* 
 * condition: a "condition variable" is a synchronization construct with 
 * three operations: wait, signal, and broadcast.  Wait puts you to sleep
 * until signalled. Signal signals the next sleeping thread, if any. Broadcast
 * signals all sleeping threads, if any.
 *
 * Part of 
 *           The STARFISH Parallel file-system simulator
 *      (Simulation Tool for Advanced Research in File Systems)
 *
 *                              David Kotz
 *                          Dartmouth College
 *                             Version 3.0
 *                             October 1996
 *                         dfk@cs.dartmouth.edu
 */

/* $Id: condition.h,v 3.0 1996/10/18 06:05:51 dfk RELEASE3 dfk $ */

#ifndef CONDITION_H
#define CONDITION_H

/* The Condition data structure */
typedef struct Condition_s CONDITION;
typedef struct Waiter_s WAITER;
struct Condition_s {
    /* please don't mess with the internals */
    WAITER *first, *last;     /* begin and end of queue */
};

extern void ConditionInit(CONDITION *c); /* initialize this condition */
extern boolean ConditionEmpty(CONDITION *c); /* is this condition empty? */
extern void ConditionPrint(CONDITION *c); /* print the tids in condition */

extern void ConditionWait(CONDITION *c); /* wait on queue */
extern void ConditionWaitIfTrue(CONDITION *c, boolean *b); /* wait on queue if *b is true */
extern void ConditionSignal(CONDITION *c); /* wake up a waiter */
extern void ConditionBroadcast(CONDITION *c); /* wake up all waiters" */

#endif CONDITION_H
