/* @TITLE "aux.h: definitions for aux.c"*/
/* 
 * Functions from aux.c are defined here. 
 * macros:
 *   NCFREE
 * functions:
 *   noncyc_free
 *   AllocWords
 *   noncyc_WordCopy
 *   alloc2d
 *   free2d
 *   Factor
 *
 * See also userdata.h and util.h
 *
 * Part of 
 *           The STARFISH Parallel file-system simulator
 *      (Simulation Tool for Advanced Research in File Systems)
 *
 *                              David Kotz
 *                          Dartmouth College
 *                             Version 3.0
 *                             October 1996
 *                         dfk@cs.dartmouth.edu
 */

/* $Id: aux.h,v 3.0 1996/10/18 06:05:51 dfk RELEASE3 dfk $ */

#ifndef AUX_H
#define AUX_H

#include "dmcache.h"	      /* get the basic types */

/* A non-cycle-counted free() operation */
#define NCFREE(p) {\
  CYCLE_COUNTING_OFF; \
  noncyc_free(p); \
  CYCLE_COUNTING_ON; \
}

extern void noncyc_free(void *p); /* see NCFREE above */
extern void noncyc_free2(void *dummy, void *p);

extern Word *AllocWords(int wordcount);

extern void noncyc_WordCopy(void *src, void *dest, int words);

/* Like WordCopy, but it counts time more like DMA would */
/*   also for word-aligned buffers, length in words */
extern void DMAcopy(void *src, void *dest, int copywords, int costwords);

extern void **alloc2d(int rows, int cols, int elsize);
extern void free2d(void *ptr);	      /* really (void **) */

/* Factor n, n>0, into two factors f1 and f2, so that f1 is the largest factor 
 * less than sqrt(n).  Basically, so that f1 and f2 are as close together as 
 * possible, and f1 <= f2.  
 */
extern void Factor(int n, int *f1, int *f2);

extern boolean SubsetBlock(ulong block);

#endif /* AUX_H */
