 /**************************************************************************\
 * simex.c, part of simex
 *
 *  David Kotz, 1996
 *
 *  simex is a stripped-down version of stats, in which I tossed all 
 * of the GUI and graph-making stuff.  It's just enough to read events.sim
 * and print out the metrics. 
 *
 * DERIVED FROM
 *                 Proteus Parallel-Architecture Simulator                
 *                Eric A. Brewer  and  Chris N. Dellarocas                
 *                     Laboratory for Computer Science                    
 *                  Massachusetts Institute of Technology                 
 *
 * Module: stats.cc
 *
 * Description:                                                           
 *         Primary stats file
 *
 * Last Modified: 9-19-91 (eab)
 * 
 * Global Functions:                                                      
 *     int main(int argc, char **argv)
 *
 ****************************************************************************
 *   Copyright 1991-1994                                                 
 *   Eric A. Brewer  and  Chris N. Dellarocas                             
 *   Massachusetts Institute of Technology                                
 *                                                                        
 *   Permission to use, copy, modify, and distribute this program         
 *   for any purpose and without fee is hereby granted, provided          
 *   that this copyright and permission notice appear on all copies       
 *   and supporting documentation, the name of M.I.T. not be used         
 *   in advertising or publicity pertaining to distribution of the        
 *   program without specific prior permission, and notice be given       
 *   in supporting documentation that copying and distribution is         
 *   by permission of M.I.T.  M.I.T. makes no representations about       
 *   the suitability of this software for any purpose.  It is pro-        
 *   vided "as is" without express or implied warranty.		          
 \**************************************************************************/

#include <stdio.h>
#include <string.h>
#include <memory.h>
#include "simex.h"

extern short params_loaded;

LIBRARY void system(char *cmd), exit(int);
LIBRARY long atol(char *);

GLOBAL float version_number = 4.1;
GLOBAL char *date_string = "July 1, 1996", version_string[40];
GLOBAL char *event_filename = "events.sim";
GLOBAL char *types_filename = "events.h";
GLOBAL char *usertypes_filename = "user-events.h";
GLOBAL BOOL debug = FALSE;
GLOBAL BOOL is_sorted = FALSE;
GLOBAL BOOL display_trace = FALSE;
GLOBAL BOOL verbose = FALSE;
GLOBAL BOOL all_metrics = FALSE;

/****************************************************************************/

GLOBAL int main(int argc, char **argv)
{
    HandleArgs(argc, argv);

    if (verbose) 
      PrintVersion();

    LoadEventNames();

    if (verbose)
      fprintf(stderr, "Loading `%s'\n", event_filename);

    if (display_trace)
      LoadEvents(event_filename, display_trace);
    else {
      LoadOnlyMetrics(event_filename);

      if (!params_loaded) 
	LoadParams("params.sim");
      
      if (all_metrics) {
	PrintAllScalarMetrics();
	PrintAllArrayMetrics();
      } else 
	PrintSelectedMetrics();
    }

    exit(0);
}
