#include <stdio.h>

#define MAX_CHARS 200

char tmp[MAX_CHARS];

main(argc, argv)
int argc;
char *argv[];
{
    int i, len;
    FILE *fil, *out;

    if (argc < 2) {
	fprintf(stderr, "Usage: saveparams <fil1> <fil2> ... <filN>\n");
	exit(1);
    }

    out = fopen("params.s", "w");
    if (out == NULL) {
	fprintf(stderr, "Unable to open output file `params.s'.\n");
	exit(1);
    }

    fprintf(out, " # params.s: simulator parameters data object\n");
    fprintf(out,
	    " # Copyright 1991, Eric A. Brewer and Chris N. Dellarocas\n");
    fprintf(out, "\n\t.data\n\t.globl\tparams_\nparams_:\n");

    for (i=1; i<argc; i++) {
	fil = fopen(argv[i], "r");
	if (fil == NULL) {
	    fprintf(stderr, "Unable to open file `%s'.\n", argv[i]);
	    system("/bin/rm params.s");
	    exit(1);
	}
	/* read parameter file */
	while (fgets(tmp, MAX_CHARS, fil)) {
	    /* replace newline with "\n" */
	    len = strlen(tmp);
	    tmp[len - 1] = '\\';
	    tmp[len] = 'n';
	    tmp[len + 1] = 0;
	    fprintf(out, "\t.ascii \"%s\"\n", tmp);
	}
	fclose(fil);
	putc('\n', out);
    }
    fprintf(out, "\t.byte  0\n\n");
    fclose(out);
    fprintf(stderr, "Built params.s\n");
}
