/*
   Routines for recording performance specification events
   Users should use macros in perfspec.h which turn off cycle counting
   and pay attention to the MONITORING_ON flag.

   (Not a supported Proteus feature---under development.)
   Written by Sharon E. Perl  Thu Sep  5 16:39:57 EDT 1991 
 */

#include "sim.h"
#include "user.h"
#include "specevents.h"
#include "rqtime.h"
#include "monitorswitch.h"

#ifdef MONITORING_ON

GLOBAL void pspec_startop(typ, instid)
unsigned long typ, instid;
/* start a typ operation. instid is the instance id for the operation. spec
   is the specid. Also attaches the current thread to instid. */
  {
    user_index_event_(EV_STARTOP, typ, instid);
    user_time_event_(EV_ATTACHTHREAD, 0, instid);
    user_index_time_event_(EV_RQTIME, RQMINUS, RQPLUS, RQTIME);
  }

GLOBAL void pspec_endop(typ, instid)
unsigned long typ, instid;
/* end a type operation with instance id instid. spec is the spec id. */
  {
    user_index_event_(EV_ENDOP, typ, instid);
    user_index_time_event_(EV_RQTIME, RQMINUS, RQPLUS, RQTIME);
  }

GLOBAL void pspec_starttimer(typ, instid)
unsigned long typ, instid;
/* start a typ timer for all active operations with instance id instid and
   spec id spec. */
  {
    user_index_event_(EV_STARTTIMER, typ, instid);
    user_index_time_event_(EV_RQTIME, RQMINUS, RQPLUS, RQTIME);
  }

GLOBAL void pspec_endtimer(typ, instid)
unsigned long typ, instid;
/* end a typ timer for all active operations with instance id instid
   and spec id spec. */
  {
    user_index_event_(EV_ENDTIMER, typ, instid);
    user_index_time_event_(EV_RQTIME, RQMINUS, RQPLUS, RQTIME);
  }

GLOBAL void pspec_inccounter(typ, instid)
unsigned long typ, instid;
/* increment a typ counter for all active operations with instance id instid
   and spec id spec.*/
  {
    user_index_time_event_(EV_INCCOUNTER, (typ&0xffc000)>>14, typ&0x03ff,
			   instid);
  }

GLOBAL void pspec_recparam(typ, instid, value)
unsigned long typ, instid, value;
/* record a typ parameter with the given value for all active operations
   with instance id instid and spec id spec. */
  {
    user_index_time_event_(EV_RECPARAM, typ, instid, value);
  }

GLOBAL void pspec_recglobal(typ, value)
unsigned long typ, value;
/* record a typ global with the given value for spec id spec. */
  {
    user_index_time_event_(EV_RECGLOBAL, (typ&0xffc000)>>14, typ&0x03ff,
			   value);
  }

GLOBAL void pspec_attachinst(spec, instid)
unsigned long spec, instid;
/* attach the current thread to operation instance instid for spec id spec. */
  {
    user_index_time_event_(EV_ATTACHTHREAD, spec, 0, instid);
    user_index_time_event_(EV_RQTIME, RQMINUS, RQPLUS, RQTIME);
  }


GLOBAL void pspec_detachinst(spec, instid)
unsigned long spec, instid;
/* detach the current thread from operation instance instid for spec id spec. */
  {
    user_index_time_event_(EV_DETACHTHREAD, spec, 0, instid);
    user_index_time_event_(EV_RQTIME, RQMINUS, RQPLUS, RQTIME);
  }

#endif
