 /**************************************************************************\
 *
 *                 Proteus Parallel-Architecture Simulator
 *                Eric A. Brewer  and  Chris N. Dellarocas
 *                     Laboratory for Computer Science
 *                  Massachusetts Institute of Technology
 *
 * Module: mem.h
 *
 * Description: Header file for memory management module
 *
 * Last Modified: $Date ($Author)
 *
 * Data Structures:
 *      StkBlk: Information structure kept for every heap block in separate
 *              page table (pagetab)
 *      FullEmpty
 *     
 * Constants:
 *     MIN_STK_POOL
 *     STK_BLK_MASK
 *     FL_NULL
 *
 * Macros:
 *     roundpage(a)
 *
 * Referenced parameters: none
 *
 ***************************************************************************
 *   Copyright 1991
 *   Eric A. Brewer  and  Chris N. Dellarocas
 *   Massachusetts Institute of Technology
 *
 *   Permission to use, copy, modify, and distribute this program
 *   for any purpose and without fee is hereby granted, provided
 *   that this copyright and permission notice appear on all copies
 *   and supporting documentation, the name of M.I.T. not be used
 *   in advertising or publicity pertaining to distribution of the
 *   program without specific prior permission, and notice be given
 *   in supporting documentation that copying and distribution is
 *   by permission of M.I.T.  M.I.T. makes no representations about
 *   the suitability of this software for any purpose.  It is pro-
 *   vided "as is" without express or implied warranty.		
 ***************************************************************************
 * $Header: /psg/proteus/RCS/mem.h,v 1.2 92/09/24 12:05:12 brewer Exp $
 * $Log:	mem.h,v $
 * Revision 1.2  92/09/24  12:05:12  brewer
 * Added ifndef at the top
 * 
 * Revision 1.1  92/02/11  14:19:50  brewer
 * Initial revision
 * 
 \**************************************************************************/

#ifndef _MEM_H_
#define  _MEM_H_

#define MIN_STK_POOL    128

#define STK_BLK_MASK    (STK_BLK_SIZE-1)  /* Mask for roundpage */

#define FL_NULL         -1                /* End of free list indicator */


/* Round address a up to the nearest multiple of STK_BLK_SIZE */

#define roundpage(a)    (char *)( (STK_BLK_MASK + (ulong)(a)) & \
				  (~STK_BLK_MASK))

typedef enum { FREE, OCCUPIED } FullEmpty;

/* Information structure for every stack block */
typedef struct {
    FullEmpty status;           /* Status: FREE, OCCUPIED */
    unsigned  size;             /* Size of block in units */
    int       next;             /* Next block in free list */
} StkBlk;


#endif /* #ifndef _MEM_H_ */
