/****************************************************************************
 *                                                                          *
 *                     Parallel Architecture Simulator                      *
 *                Eric A. Brewer  and  Chris N. Dellarocas                  *
 *                     Laboratory for Computer Science                      *
 *                  Massachusetts Institute of Technology                   *
 *                                                                          *
 * Module:
 *                                                                          *
 * Description:
 *                                                                          *
 * Last Modified:
 *                                                                          *
 * Data Structures:
 *                                                                          *
 * Constants:
 *                                                                          *
 * Variables:
 *                                                                          *
 ***************************************************************************
 *   Copyright 1991
 *   Eric A. Brewer  and  Chris N. Dellarocas
 *   Massachusetts Institute of Technology
 *
 *   Permission to use, copy, modify, and distribute this program
 *   for any purpose and without fee is hereby granted, provided
 *   that this copyright and permission notice appear on all copies
 *   and supporting documentation, the name of M.I.T. not be used
 *   in advertising or publicity pertaining to distribution of the
 *   program without specific prior permission, and notice be given
 *   in supporting documentation that copying and distribution is
 *   by permission of M.I.T.  M.I.T. makes no representations about
 *   the suitability of this software for any purpose.  It is pro-
 *   vided "as is" without express or implied warranty.		
 ***************************************************************************
 * $Header: /psg/proteus/RCS/intreq.h,v 1.1 92/02/11 14:19:49 brewer Exp $
 * $Log:	intreq.h,v $
 * Revision 1.1  92/02/11  14:19:49  brewer
 * Initial revision
 * 
 \**************************************************************************/

#include "net.param"

#define MAX_INTR_REQS      (NO_OF_PROCESSORS * INTR_PER_PROCESSOR)

#define INTR_MAX_ARGS      MAX_PACKET_WORDS /* max. arguments per interrupt */

/* Simulator Request Block */

typedef struct intreq {
    Time       itime;                /* time interrupt was received */
    int        iprio;                /* interrupt priority */
    int        isender;              /* sender processor   */
    int        isendtid;             /* sender tid         */
    int        itype;                /* interrupt type     */
    int        argc;                 /* argument count     */
    Word       argv[INTR_MAX_ARGS];  /* argument vector    */
    struct intreq     *inextreq;     /* next intr request  */
} IntrRequest;

int intr_pending[NO_OF_PROCESSORS];

void init_intr_request_queue();
IntrRequest *next_intr_request();
IntrRequest *first_intr_request();
void enqueue_intr_request();
IntrRequest *new_intr_request();
void free_intr_request();
