
/****************************************************************************
 *                                                                          *
 *                     Parallel Architecture Simulator                      *
 *                Eric A. Brewer  and  Chris N. Dellarocas                  *
 *                     Laboratory for Computer Science                      *
 *                  Massachusetts Institute of Technology                   *
 *                                                                          *
 * Module: cache.c
 *                                                                          *
 * Description:                                                             *
 *                                                                          *
 * Last Modified: $Date: 92/04/01 17:01:01 $
 *                                                                          *
 * Global Functions:                                                        *
 *                                                                          *
 * Global Variables:                                                        *
 *                                                                          *
 ****************************************************************************
 *   Copyright 1991
 *   Eric A. Brewer  and  Chris N. Dellarocas
 *   Massachusetts Institute of Technology
 *
 *   Permission to use, copy, modify, and distribute this program
 *   for any purpose and without fee is hereby granted, provided
 *   that this copyright and permission notice appear on all copies
 *   and supporting documentation, the name of M.I.T. not be used
 *   in advertising or publicity pertaining to distribution of the
 *   program without specific prior permission, and notice be given
 *   in supporting documentation that copying and distribution is
 *   by permission of M.I.T.  M.I.T. makes no representations about
 *   the suitability of this software for any purpose.  It is pro-
 *   vided "as is" without express or implied warranty.
 ****************************************************************************
 * $Header: /psg/proteus/RCS/cache.c,v 1.2 92/04/01 17:01:01 brewer Exp $
 * $Log:	cache.c,v $
 * Revision 1.2  92/04/01  17:01:01  brewer
 * cleaned up gcc warnings, added ANSI prototypes
 * 
 * Revision 1.1  92/02/11  13:55:09  brewer
 * Initial revision
 * 
 \**************************************************************************/

#include "conf.param"
#include "sim.h"
#include "event.h"
#include "cache.h"

#ifndef NOCACHE
int GetLineFromAddr(int processor, Word address) 
{
    CacheSet *set = &cache[processor][GetSetFromAddr(address)];
    Word tag = GetTagFromAddr(address);
    int i;
    
#ifdef CACHEDEBUG
    printf("GETLINE(%d, %x): set = %x tag = %x\n", processor,
	   address, GetSetFromAddr(address), tag); 
#endif
    
    for(i=0; i<SET_SIZE; i++) {
#ifdef CACHEDEBUG
	char *printstate();
	if (address == 26912) printf("tag[%d] = %x state = %s\n", i,
				     set->ctag[i], printstate(set->state[i]));
#endif
	if (set->ctag[i] == tag)
	  return(i);
    }
    
    return(-1);
}

#ifdef BUS
#include "cache.bus.c"
#endif

#ifdef NET
#include "cache.net.c"
#endif
#endif
