/*
 * Assembly language routine to update profiling information.
 * void InitProfile_(address in $15)
 *    address contains the address of the storage that contains the net time
 *        and the number of calls
 *    MUST return with $25 = 0, save contents of $24
 *
 *
 * Eric A. Brewer
 * 7-12-90
 *
 * $Header: /psg/proteus/RCS/Profile.S,v 1.8 92/09/23 11:44:22 brewer Exp $
 * $Log:	Profile.S,v $
 * Revision 1.8  92/09/23  11:44:22  brewer
 * Added GetRegs, GetReg30_ for debugging support.
 * (changed file name from Profile.s to Profile.S)
 * 
 * Revision 1.7  92/04/01  17:17:13  brewer
 * changed RCS comment string to " * "
 * 
 * 
 * Revision 1.5  92/04/01  17:10:22  brewer
 * Changed to C style comments
 * 
 * Revision 1.4  92/02/13  15:51:26  brewer
 * edited r1.3 log message
 * 
 * Revision 1.3  92/02/12  16:48:21  brewer
 * changed RCS comment char to " # "
 * 
 * Revision 1.2  92/02/12  10:28:35  brewer
 * Fixed header and log info
 * 
 * Revision 1.1  92/02/11  16:07:19  brewer
 * Initial revision
 *
 */

	.text
	.align 2
	.globl  InitProfile_
	.ent	InitProfile_
InitProfile_:
	subu	$sp, 32		# allocate space on the stack
	sw	$31, 28($sp)	# save return address,
	sw	$24, 24($sp)	# save $24
	sw	$7, 20($sp)	# save arguments
	sw	$6, 16($sp)
	sw	$5, 12($sp)
	sw	$4, 8($sp)
	.mask   0x810000f0, -4
	.frame  $sp, 32, $31
	addu	$4, $0, $31	# move return address -> arg1
	addu	$5, $0, $15	# move address -> arg2
	jal	set_prof_	# set the profData pointer
	lw	$31, 28($sp)	# restore registers
	lw	$24, 24($sp)	# restore $24
	lw	$7, 20($sp)     # restore arguments
	lw	$6, 16($sp)
	lw	$5, 12($sp)
	lw	$4, 8($sp)
	addu	$sp, 32		# deallocate stack space
	addu	$25, $0, $0	# set $25 to zero
	j	$31
	.end	InitProfile_

/* Assembly code to return to the address of the point of call.  Used to
 * determine the (symbol table) name of the calling routine.
 * Eric A. Brewer
 * 9-12-90
 */

	.text
	.align 2
	.globl	GetAddress_
	.ent	GetAddress_
GetAddress_:
	addu	$2, $31, $0	# move return address to $2
	j	$31
 	.end	GetAddress_

	.globl  GetStack_
	.ent    GetStack_
GetStack_:
        addu    $2, $29, $0     # move stack pointer to $2
        j       $31
        .end    GetStack_

	.globl  GetReg30_
	.ent    GetReg30_
GetReg30_:
        addu    $2, $30, $0     # move Reg 30 (FP) to $2
        j       $31
        .end    GetReg30_

	.globl	fatal_regs	# fatal procedure registers
	.globl	GetRegs
	.ent	GetRegs
GetRegs:
				# vars= 0, regs= 0, args = 0, extra= 0
	.mask	0x00000000, 0
	.fmask	0x00000000, 0
	.frame	$sp, 0, $31

	# Save the scalar registers in area pointed to by $4
	sw	$16, 64($4)
	sw	$17, 68($4)
	sw	$18, 72($4)
	sw	$19, 76($4)
	sw	$20, 80($4)
	sw	$21, 84($4)
	sw	$22, 88($4)
	sw	$23, 92($4)

	sw	$sp, 116($4)
	sw	$30, 120($4)
	sw	$31, 124($4)

	j	$31		# return
	.end	GetRegs
