/****************************************************************************
 *                                                                          *
 *                     Parallel Architecture Simulator                      *
 *                Eric A. Brewer  and  Chris N. Dellarocas                  *
 *                     Laboratory for Computer Science                      *
 *                  Massachusetts Institute of Technology                   *
 *                                                                          *
 * Module: yyconsts.h
 *                                                                          *
 * Description: Constants used by parser
 *                                                                          *
 * Last Modified:
 *                                                                          *
 * Data Structures:
 *                                                                          *
 * Constants:
 *                                                                          *
 * Variables:
 *                                                                          *
 ****************************************************************************/


/* Symbol classes */

#define ID_VARIABLE       1
#define ID_COMPOUND       2
#define ID_TYPEDEF        3
#define ID_COMPONENT      4
#define ID_ENUMID         5
#define ID_USERIPI        6

/* Sizes */

#define SIZE_CHAR         1
#define SIZE_SHORT        2
#define SIZE_INT          4
#define SIZE_LONG         4
#define SIZE_FLOAT        4
#define SIZE_VOID         4
#define SIZE_PTR          4
#define SIZE_ENUM         4
#define SIZE_DOUBLE       8

/* RID definitions */

#define NORID		-1

/*  TYPESPECs */

#define RID_CHAR	  0
#define RID_DOUBLE	  1
#define RID_FLOAT	  2
#define RID_INT		  3
#define RID_LONG	  4
#define RID_SHORT	  5
#define RID_VOID	  6
#define RID_STRUCT        7
#define RID_UNION         8
#define RID_ENUM          9
#define RID_PTR          10
#define RID_FUNC         11
#define RID_ARRAY        12

/* SCSPECs */

#define RID_AUTO	000001
#define RID_EXTERN	000002
#define RID_INLINE	000004
#define RID_REGISTER	000010
#define RID_SHARED	000020
#define RID_STATIC	000040
#define RID_TYPEDEF	000100

/* TYPE_QUALs */

#define RID_CONST	000200
#define RID_SIGNED	000400
#define RID_TAGGED	001000
#define RID_UNSIGNED	002000
#define RID_UNTAGGED	004000
#define RID_VOLATILE	010000
#define RID_TAGACCESS   020000
#define RID_SOFT        040000

/* Operator codes for abbreviated assignment ops */

#define	PLUS_EXPR		1
#define	MINUS_EXPR		2
#define BIT_AND_EXPR		3
#define BIT_IOR_EXPR		4
#define MULT_EXPR		5
#define TRUNC_DIV_EXPR		6
#define TRUNC_MOD_EXPR		7
#define BIT_XOR_EXPR		8
#define LSHIFT_EXPR		9
#define RSHIFT_EXPR		10

#define EQ_EXPR                 11
#define NEQ_EXPR                12
#define LESS_EXPR               13
#define GRT_EXPR                14
#define LEQ_EXPR                15
#define GEQ_EXPR                16

#define AND_EXPR                17
#define OR_EXPR                 18

/* Codes for unary operators */

#define AMPERSAND_UNARY         31
#define MINUS_UNARY             32
#define PLUS_UNARY              33
#define PLUSPLUS_UNARY          34
#define MINUSMINUS_UNARY        35
#define NEGATE_UNARY            36
#define NOT_UNARY               37
