
#include "cprep.h"
#include "symtable.h"


void unary_star(Lex *star, Expr *expr)
{ 
    Type *type = expr->type;
    
    switch ( TID(type) )
      {
	case RID_PTR:
	case RID_ARRAY:
	  expr->type = (Type *)type->link;
	  break;
	default:
	  expr->type = (Type *)NULL;
	  warning("star before something that is not pointer or array");
      }
    
    
    if ( ! (expr->attributes & RID_SHARED) )
      expr->val = link_chain2( star->text, expr->val );
    else {
	warning("star before an expression that evaluates to a shared memory address");
	free_chain(expr->addr);
	expr->addr = (StrTab *)NULL;
	expr->val = parenthesize(link_chain3(star->text, 
					     make_type_text(type), 
					     parenthesize(expr->val) ) );
    }
    
    expr->attributes &= (~RID_SHARED);
}


void unary_at(Lex *at, Expr *expr)
{
    Type *type = expr->type;
    
    switch ( TID(type) )
      {
	case RID_PTR:
	case RID_ARRAY:
	  expr->type = (Type *)type->link;
	  break;
	default:
	  expr->type = (Type *)NULL;
	  warning("at before something that is not pointer or array");
      }
    
    expr->addr = expr->val;
    
    switch( TID(expr->type) )
      {
	case RID_ARRAY:
	case RID_STRUCT:
	case RID_UNION:
	  expr->val = copy_chain(expr->addr);
	  break;
	default:
	  expr->val = make_shared_read(expr->addr, expr->type, expr->attributes);
      }
    
    expr->attributes |= RID_SHARED;
    
    free_chain(at->text);
}


Type *insert_pointer(Type *t)
{
    Type *newt = newtype();
    
    newt->tid = RID_PTR;
    newt->text = (StrTab *)NULL;
    newt->size = SIZE_PTR;
    newt->link = t;
    
    return( newt );
}


/* REMEMBER TO ADD STATEMENTS TO UPDATE NUMVAL */

void unary_op(Lex *op, Lex *e)
{
    
    Expr *expr = (Expr *)e->tinfo;
    
    switch( op->tinfo )
      {
	case AMPERSAND_UNARY:
	  
	  expr->type = insert_pointer(expr->type);
	  expr->numval = NONUMVAL;
	  
	  if ( ! (expr->attributes & RID_SHARED) ) {
	      expr->val = link_chain2(op->text, expr->val);
	      return;
	  }
	  
	  if ( expr->addr != (StrTab *)NULL) {
	      free_chain(expr->val);
	      expr->val = parenthesize( link_chain2(make_type_text(expr->type),
						    parenthesize(expr->addr) ) );
	      expr->addr = (StrTab *)NULL;
	  }
	  else
	    error("invalid & operand");
	  
	  free_chain(op->text);
	  break;
	  
	  /* Unary expression type remains type of operand */
	case MINUS_UNARY:
	  if ( expr->numval != NONUMVAL )
	    expr->numval = (- expr->numval);
	  expr->val = link_chain2(op->text, expr->val);
	  break;
	case PLUS_UNARY:
	  expr->val = link_chain2(op->text, expr->val);
	  break;
	case PLUSPLUS_UNARY:
	case MINUSMINUS_UNARY:
	  make_increment_decrement( e, op, PRE );
	  break;
	case NEGATE_UNARY:
	  if ( expr->numval != NONUMVAL )
	    expr->numval = ( ~expr->numval);
	  expr->val = link_chain2(op->text, expr->val);
	  break;
	case NOT_UNARY:
	  if ( expr->numval != NONUMVAL )
	    expr->numval = ( !expr->numval);
	  expr->val = link_chain2(op->text, expr->val);
	  break;
	  
      }
}



void unary_sizeof(Lex *sizof, Expr *expr)
{
    Type *type = expr->type;
    
    free_chain(expr->addr);
    expr->addr = (StrTab *)NULL;
    expr->val  = link_chain2(sizof->text, parenthesize(expr->val));
    expr->type = (Type *)NULL;
    expr->numval = SIZE(type) > 0 ? SIZE(type) : NONUMVAL;
    expr->attributes = 0;
}


void unary_sizeof_typename(Lex *sizof, Lex *left, Lex *typenam, Lex *right)
{
    Expr *expr = newexpr();
    Type *type = (Type *)typenam->tinfo;
    
    expr->addr = (StrTab *)NULL;
    expr->val  = link_chain4(sizof->text, left->text,
			     typenam->text, right->text);
    expr->type = (Type *)NULL;
    expr->numval = SIZE(type) > 0 ? SIZE(type) : NONUMVAL;
    expr->attributes = 0;
    
    sizof->tinfo = (Word)expr;
}


void unary_tag(Lex *tag, Expr *expr)
{
    
    if ( !( expr->attributes & RID_SHARED) ) {
	error("tag expression has nonshared operand");
	goto free1;
    }
    
    if ( expr->addr == (StrTab *)NULL ) {
	error("tag operand must be a lvalue");
	goto free1;
    }
    
    expr->attributes |= RID_TAGACCESS;
    
    expr->val = make_shared_read(expr->addr, NULL, expr->attributes);
    expr->type = (Type *)NULL;
    
  free1:
    free_chain(tag->text);
}
