
#include <string.h>
#include "cprep.h"
#include "symtable.h"

extern int lineno;

int sym_debug = 0;

int TREELEVEL;

int insert_symbol(Symbol *symbol, Symbol **tree)
{
    int cmp;
    
#ifdef TREEDEBUG
    printf("#%d INSERT SYMBOL %s Attributes = %d Current tree node : %s ", 
	   TREELEVEL, TEXT(symbol->text), symbol->attributes,
	   (*tree == (Symbol *)NULL ? "<NULL>" : TEXT((*tree)->text)) );
    if ( symbol->type != (Type *)NULL )
      printf("Size = %d bytes\n", SIZE(symbol->type));
    else
      printf("\n");
#endif
    
    if ( *tree == (Symbol *)NULL) {
	*tree = symbol;
	
	if (sym_debug) {
	    printf("insert_symbol(%d):", lineno);
	    print_symbol(symbol); 
	}

	if ( symbol->class == ID_TYPEDEF && symbol->type != (Type *)NULL )
	  symbol->type->backlink = symbol;
	
	symbol->left = symbol->right = (Symbol *)NULL;
	
	return(OK);
    }
    
    if ( !(cmp = strcmp(TEXT(symbol->text), TEXT((*tree)->text)) ) ) {
	if ( !xdecls_flag ) {
	    /*
	      warning("symbol `%s' may be multiply defined",
	      TEXT(symbol->text) );
	      */
	} else {
#ifdef TREEDEBUG
	    printf("while in xdecls found duplicate symbol `%s'\n",
		   TEXT(symbol->text));
	    printf("its type is %08x tid = %d\n",
		   (*tree)->type, TID((*tree)->type));
#endif
	    /*
	      if ( (*tree)->type == (Type *)NULL )
	      */
	    (*tree)->type = symbol->type;
	}
	return(DUPLICATE);
    }
    else if ( cmp > 0)
      return( insert_symbol(symbol, &(*tree)->right) );
    else
      return( insert_symbol(symbol, &(*tree)->left)  );
}



Symbol *lookup_symbol(char *name, Symbol *tree)
{
    int cmp;
    
    if (tree == (Symbol *)NULL)
      return( (Symbol *)NOTFOUND );
    
#ifdef LTREEDEBUG
    printf("%s, ", TEXT(tree->text) );
#endif
    
    if ( !(cmp = strcmp(name, TEXT(tree->text) )) ) 
      return( tree );
    else if ( cmp > 0 )
      return( lookup_symbol(name, tree->right) );
    else
      return( lookup_symbol(name, tree->left) );
}


Symbol *lookup_symbol_rec(char *name, Symbol **tree)
{
    int i;
    Symbol **t;
    Symbol *sym;
    
#ifdef LTREEDEBUG
    printf("#%d.LOOKUP SYMBOL %s (((", curr_tree_level, name);
#endif
    
    for( i = curr_tree_level, t = tree; i >= 1; i--, t--)
      if ( (sym = lookup_symbol(name, *t)) != (Symbol *)NOTFOUND ) {
#ifdef LTREEDEBUG
	  printf(" ))) Class = %d\n", sym->class);
#endif
	  return( sym );
      }
    
#ifdef LTREEDEBUG
    printf(" ))) NOTFOUND\n");
#endif
    return( (Symbol *)NOTFOUND );
}




Symbol *lookup_component(char *name, Symbol *list)
{
    Symbol *l;
    
#ifdef LTREEDEBUG
    printf("LOOKUP COMPONENT %s (((", name);
#endif
    
    for( l = list; l != (Symbol *)NULL; l = l->right ) {
#ifdef LTREEDEBUG
	printf(" %s" , TEXT(l->text) );
#endif
	if ( ! strcmp(name, TEXT(l->text)) ) 
	  return( l );
    }
    
    return( (Symbol *)NOTFOUND );
}




Lex lookup_structure(Lex *name, int create)
{
    
    Lex result;
    char sname[65];
    Symbol *sym;
    Symbol **t;
    int i;
    
    strcpy(sname, "struct ");
    strcat(sname, TEXT(name->text) );
    
    for( i = curr_tree_level, t = currtree; i >= 0; i--, t--) {
	if ( (sym = lookup_symbol(sname, *t)) != (Symbol *)NOTFOUND ) {
	    if ( sym->class != ID_COMPOUND || sym->type->tid != RID_STRUCT ) {
		error("symbol `%s' is not a struct", TEXT(name->text));
		result.tinfo = (Word)NULL;
		return result;
	    } else {
		result.tinfo = (Word)sym;
		return result;
	    }
	}
    }

    if (create) {
	make_empty_structure(name);
	result.tinfo = name->tinfo;
	return result;
    } else {
	result.tinfo = NULL;
	return result;
    }
}



Lex lookup_union(Lex *name, int create)
{
    
    Lex result;
    char sname[65];
    Symbol *sym;
    Symbol **t;
    int i;
    
    strcpy(sname, "union ");
    strcat(sname, TEXT(name->text) );
    
    for( i = curr_tree_level, t = currtree; i >= 0; i--, t--)
      if ( (sym = lookup_symbol(sname, *t)) != (Symbol *)NOTFOUND ) {
	  if ( sym->class != ID_COMPOUND || sym->type->tid != RID_UNION ) {
	      error("symbol `%s' is not a union", TEXT(name->text));
	      result.tinfo = (Word)NULL;
	      return result;
	  }
	  else {
	      result.tinfo = (Word)sym;
	      return result;
	  }
      }
    
    if (create) {
	make_empty_structure(name);
	result.tinfo = name->tinfo;
	return result;
    } else {
	result.tinfo = NULL;
	return result;
    }
}



Lex lookup_enum(Lex *name)
{
    Lex result;
    char sname[65];
    Symbol *sym;
    Symbol **t;
    int i;
    
    strcpy(sname, "enum ");
    strcat(sname, TEXT(name->text) );
    
    for( i = curr_tree_level, t = currtree; i >= 0; i--, t--)
      if ( (sym = lookup_symbol(sname, *t)) != (Symbol *)NOTFOUND ) {
	  if ( sym->class != ID_COMPOUND || sym->type->tid != RID_ENUM ) {
	      error("symbol `%s' is not an enum", TEXT(name->text));
	      goto fail;
	  }
	  else {
	      result.tinfo = (Word)sym;
	      return result;
	  }
      }
    
    error("symbol `%s' is undefined", TEXT(name->text));
  fail:
    result.tinfo = (Word)NULL;
    return result;
}


void print_type(Type *t)
{
    if (t < (Type *)0x10000000) {
	printf("Type: 0x%lx\n", (unsigned long)t);
	return;
    }
    printf("Type: %d, qualifiers, 0x%x, size=%d, elements=%d\n\t",
	   t->tid, t->typequals, t->size, t->totelem);
    print_chain(t->text);
}

void print_symbol(Symbol *s)
{
    if (s < (Symbol *)0x10000000) {
	printf("Symbol: 0x%lx\n", (unsigned long) s);
	return;
    }
    printf("Symbol: class=%d, att=%d\n\t", s->class, s->attributes);
    print_chain(s->text);
    putchar('\t');
    print_type(s->type);
}


/*** debugging tools ***/

Symbol *the_sym = (Symbol *) 0x10240e80;

void catch(int lineno)
{
    printf("**** catch %d ****\n", lineno);
}

void newline(int lineno)
{
}
