
#include <signal.h>
#include "cprep.h"
#include "symtable.h"

float version_number = 3.0;
char *date_string = "November 9, 1992";

FILE *finput, *foutput, *finitmem, *fipic;
char *input_filename, *output_filename;
char is_filename[64];
int lineno;
char silent_flag = FALSE, profile_flag = FALSE, insert_stmt_flag = FALSE;

#define out stderr

#ifdef __STDC__
#include <stdarg.h>

GLOBAL void error(const char *fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);

    fprintf(out, "%s:%d: error:", input_filename, lineno);
    vfprintf(out, fmt, ap);
    fprintf(out, "\n");
    error_flag++;
    va_end(ap);
}

GLOBAL void warning(const char *fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);

    if (silent_flag) return;

    fprintf(out, "%s:%d: warning:", input_filename, lineno);
    vfprintf(out, fmt, ap);
    fprintf(out, "\n");
    va_end(ap);
}

GLOBAL void fatal(const char *fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);

    fprintf(out, "Fatal Error: %s:%d:\n\t", input_filename, lineno);
    vfprintf(out, fmt, ap);
    fprintf(out, "\n");
    exit(34);
    va_end(ap);
}

#else /* not __STDC__, assume Ultrix cc compiler */

#include <varargs.h>

GLOBAL void error(va_alist)
    va_dcl
{
    va_list ap;
    va_start(ap);

    fprintf(out, "%s:%d: error:", input_filename, lineno);
    vfprintf(out, va_arg(ap, char *), ap);
    fprintf(out, "\n");
    error_flag++;
    va_end(ap);
}

GLOBAL void warning(va_alist)
    va_dcl
{
    va_list ap;
    va_start(ap);

    if (silent_flag) return;

    fprintf(out, "%s:%d: warning:", input_filename, lineno);
    vfprintf(out, va_arg(ap, char *), ap);
    fprintf(out, "\n");
    va_end(ap);
}

GLOBAL void fatal(va_alist)
    va_dcl
{
    va_list ap;
    va_start(ap);

    fprintf(out, "Fatal Error: %s:%d:\n\t", input_filename, lineno);
    vfprintf(out, va_arg(ap, char *), ap);
    fprintf(out, "\n");
    
    exit(34);
    va_end(ap);
}

#endif /* ifdef __STDC__ */


GLOBAL void die_gracefully()
{
    error("cannot recover from previous errors - goodbye !", 0, 0);
    exit(1);
}



void init_output()
{
    fprintf(foutput,"# 1 \"%s\"\n", input_filename);
    fprintf(foutput,"typedef char * __SHARED__ ;\n\n");
}



static void make_is_filename(char *s, char *t)
{
    char c;
    while( (c = *t++ = *s++) && c != '.' );
    *t++ = 'i', *t++ = 's', *t = 0;
}



/* interpret command line arguments */
static void HandleArgs(int argc, char *argv[])
{
    int i;
    BOOL ifile_def, ofile_def;
    
    output_filename = "";
    
    for (i=1, ifile_def=FALSE, ofile_def=FALSE; i<argc; i++) {
	if (argv[i][0] == '-') {
	    switch (argv[i][1]) {
	      case 'v':
		printf("catoc: Version %.2f  %s\n", version_number,
		       date_string);
		printf("Copyright 1992, Eric A. Brewer and Chris N. Dellarocas\n");
		printf("Massachusetts Institute of Technology\n");
		break;
	      case 'p':
		profile_flag = TRUE;
		break;
	      case 's':
		silent_flag = TRUE;
		break;
	      case 'i':
		if (++i == argc) {
		    fprintf(stderr, "Missing filename after '-i' option.\n");
		    exit(1);
		}
		input_filename = argv[i];
		break;
	      case 'o':
		if (++i == argc) {
		    fprintf(stderr, "Missing filename after '-o' option.\n");
		    exit(1);
		}
		output_filename = argv[i];
		foutput = fopen(argv[i], "w");
		if (foutput == NULL) {
		    fprintf(stderr,
			    "Unable to open file \"%s\" for writing.\n",
			    argv[i]);
		    exit(1);
		}
		ofile_def = TRUE;
		/* fprintf(stderr, "Writing to file \"%s\".\n", argv[i]); */
		break;
	      default:
		fprintf(stderr, "Unknown command line option: %s\n",
			argv[i]);
	    }
	} else {
	    if (ifile_def)
	      fprintf(stderr,  "Warning: input filename redefined from \"%s\" to \"%s\".\n",
		      input_filename, argv[i]);
	    input_filename = argv[i];
	    finput = fopen(input_filename, "r");
	    if (finput == 0)
	      {
		  fprintf(stderr, "Unable to open file \"%s\" for reading\n",
			  input_filename);
		  exit(1);
	      }
	    ifile_def = TRUE;
	}
    }
    if (!ifile_def) {
	finput = stdin;
    }
    if (!ofile_def) {
	fprintf(stderr,"No output filename specified.\n");
	exit(1);
	/*
	  foutput = stdout;
	  */
    }
}



void main(argc, argv)
     int argc;
     char **argv;
{
    
    HandleArgs(argc, argv);
    
    make_is_filename(output_filename, is_filename);
    
    finitmem = fipic = fopen(is_filename,"w");
    if ( finitmem == 0 )
      {
	  fprintf(stderr, "cannot open %s for writing\n", is_filename);
	  exit(3);
      }
    
    /*
      fprintf(finitmem,"typedef char * __SHARED__;\ninitshared()\n{\n");
      */
    init_strings();
    init_tree();
    init_decl();
    init_lex();
    
    init_output();
    
    signal(SIGINT, die_gracefully);
    signal(SIGBUS, die_gracefully);
    signal(SIGSEGV, die_gracefully);
    signal(SIGILL, die_gracefully);
    
    yyparse();
    
    outnl();
    
    if (error_flag) {
	fprintf(stderr, "\t%d errors found.", error_flag);
	exit(1);
    }
}

