/****************************************************************************
 *                                                                          *
 *                     Parallel Architecture Simulator                      *
 *                Eric A. Brewer  and  Chris N. Dellarocas                  *
 *                     Laboratory for Computer Science                      *
 *                  Massachusetts Institute of Technology                   *
 *                                                                          *
 * Module: cprep.h
 *                                                                          *
 * Description: Main constants and definitions used in C preprocessor
 *                                                                          *
 * Last Modified:
 *                                                                          *
 * Data Structures:
 *                                                                          *
 * Constants:
 *                                                                          *
 * Variables:
 *                                                                          *
 ****************************************************************************/

#define GLOBAL
#define LIBRARY extern

#ifdef __STDC__
void error(const char *, ...), warning(const char *, ...);
void fatal(const char *, ...);
#else /* not __STDC__ */
void error(), warning(), fatal();
#ifdef ultrix  /* ultrix cc compiler does not support "const" */
#define const
#endif /* ultrix */
#endif /* __STDC__ */


#include <stdio.h>

#include "yyconsts.h"
#include "simconsts.h"

/* Constants used throughout the program */

typedef char  Bool;

#define ERROR             -1
#define OK                 0
#define FALSE              0
#define TRUE               1
#define BOOL               char
#define EMPTY              0
#define FULL               1
#define YES                TRUE
#define NO                 FALSE
#define NOTFOUND           NULL
#define DUPLICATE          ERROR
#define FREEYES            TRUE
#define FREENO             FALSE
#define PRE                -1
#define POST               1

#define NONUMVAL           12345678

#define MAX_TOKEN          1024

/* Type definitions */

typedef unsigned long      ulong;
typedef unsigned long      Word;

typedef Word (*FuncPtr)();

#define max(a,b)           ( (a) > (b) ? (a) : (b) )
#define TEXT(s)            ((char *)&(s)->text)

#define ALIGN_MASK         (sizeof(Word)-1)
#define ALIGN(x)           ( (ALIGN_MASK + (unsigned)(x)) & (~ALIGN_MASK) )
#define ROUND(x,s)         ( (((s)-1) + (unsigned)(x)) & (~((s)-1)) )
#define SIZE(t)            ( (t) != (Type *)NULL ? (t)->size : SIZE_INT )
#define TID(t)             ( (t) != (Type *)NULL ? (t)->tid  : NORID    )

#define YYSTYPE            Lex
#define YYMAXDEPTH         300

#define TREEOF(x)          (&tree_stack[TREELEVEL = ((Symbol *)((x).tinfo))->level])

/* Various flags */

#define SHARED_FLAG        ( currdecl->attributes & RID_SHARED )
#define TYPEDEF_FLAG       ( currdecl->attributes & RID_TYPEDEF )
#define SAVEPARMS_FLAG     ( currdecl->parameters )
#define SAVEPARMS_FLAG_1   ( currdecl[-1].parameters )


#define parenthesize(expr) link_chain3(allocate_string("("), \
                                       (expr), \
				       allocate_string(")") )

/* function prototypes */
LIBRARY void exit(int status);
LIBRARY int atoi(char *);
LIBRARY long strtol(char *str, char **last, int base);
int yyparse(void);
void init_strings(void), init_tree(void), init_decl(void), init_lex(void);

