 
 /**************************************************************************\
 *                                                                          *
 *                 Proteus Parallel-Architecture Simulator                  *
 *                Eric A. Brewer  and  Chris N. Dellarocas                  *
 *                     Laboratory for Computer Science                      *
 *                  Massachusetts Institute of Technology                   *
 *                                                                          *
 * Module:  catis                                                           *
 *                                                                          *
 * Description:  Transform a list of filenames into the equivalent list     *
 *    of <basname>.is filenames                                             *
 *                                                                          *
 * Last Modified:  1-14-92 (eab)                                            *
 *                                                                          *
 ****************************************************************************
 *   Copyright 1991                                                         *
 *   Eric A. Brewer  and  Chris N. Dellarocas                               *
 *   Massachusetts Institute of Technology                                  *
 *                                                                          *
 *   Permission to use, copy, modify, and distribute this program           *
 *   for any purpose and without fee is hereby granted, provided            *
 *   that this copyright and permission notice appear on all copies         *
 *   and supporting documentation, the name of M.I.T. not be used           *
 *   in advertising or publicity pertaining to distribution of the          *
 *   program without specific prior permission, and notice be given         *
 *   in supporting documentation that copying and distribution is           *
 *   by permission of M.I.T.  M.I.T. makes no representations about         *
 *   the suitability of this software for any purpose.  It is pro-          *
 *   vided "as is" without express or implied warranty.		            *
 \**************************************************************************/


#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>

static void make_is_filename(const char *s, char *t) 
{
    char c;
    while( (c = *t++ = *s++) && c != '.' );
    *t++ = 'i', *t++ = 's', *t = 0;
}


int main(int argc, char **argv) 
{
    int i, fp, n;
    char is_filename[128];
    char buffer[1024];

    for(i=1; i<argc; i++) {
	make_is_filename(argv[i], is_filename);
	if ( (fp = open(is_filename, O_RDONLY, 0)) < 0) {
	    fprintf(stderr, "Cannot open file \"%s\" for reading.\n",
		    is_filename);
	    continue;
	}
	while( ( n = read(fp, buffer, sizeof(buffer))) > 0)
	  write(1, buffer,n);
	close(fp);
    }
    return(0);
}

