/*
 * Assembly language routines for printf variants without using
 * stack space.
 *
 * Eric A. Brewer
 * 10-28-92
 */

	.extern stackmin_ 4

	.data
	.word	0:1024		# allocate 4k bytes as temporary stack
tmp_stack:
	.word	0:32		# allocate 32 words to copy in stack info
old_stack:
	.word	0:2

	.text
	.align 2
/*
 *  do_printf_:
 *      Uses tmp_stack as a statically allocated stack area,
 *	so that calls to printf (and variants) don't cause stack overflow
 *	which is far more likely in the presence of lots of small threads.
 *	do_printf_ is called from the printf wrappers below, the address
 *	of the appropriate real printf procedure (the one in the library)
 *	is passed in via register $15.
 *
 *	Steps:
 *		1) copies 32 args from real stack to tmp_stack
 *		2) sets $sp to be the address of tmp_stack
 *		3) calls printf variant, which is passed in via $15
 *		4) restores $sp
 *		5) return to original caller of printf wrapper
 */

	.ent	do_printf_
do_printf_:
	.mask   0x00000000, 0
	.frame  $sp, 0, $31
	la	$25, tmp_stack
	move	$24, $sp
	li	$12, 8
L1:	lw	$8, 0($24)
	lw	$9, 4($24)
	lw	$10, 8($24)
	lw	$11, 12($24)
	sw	$8, 0($25)
	sw	$9, 4($25)
	sw	$10, 8($25)
	sw	$11, 12($25)
	sub	$12, $12, 1
	add	$25, $25, 16
	add	$24, $24, 16
	bgtz	$12, L1
	sw	$sp, old_stack
	la	$sp, tmp_stack
	sw	$31, old_stack+4
	jal	$15		# call appropriate printf variant
	lw	$31, old_stack+4
	lw	$sp, old_stack
	j	$31
	.end	do_printf_

/* printf wrappers:
 *
 *	Theses just place the appropriate address in $15 and jump to
 *	do_printf_.
 */

	.globl  printf
	.ent	printf
printf:
	.mask   0x00000000, 0
	.frame  $sp, 0, $31
	la	$15, print_
	j	do_printf_	# tail call -- do_printf_ returns directly
				#    to the caller of printf
	.end	printf

	.globl  fprintf
	.ent	fprintf
fprintf:
	.mask   0x00000000, 0
	.frame  $sp, 0, $31
	la	$15, fprint_
	j	do_printf_	# tail call
	.end	fprintf

	.globl  sprintf
	.ent	sprintf
sprintf:
	.mask   0x00000000, 0
	.frame  $sp, 0, $31
	la	$15, sprint_
	j	do_printf_	# tail call
	.end	sprintf

	.globl  vfprintf
	.ent	vfprintf
vfprintf:
	.mask   0x00000000, 0
	.frame  $sp, 0, $31
	la	$15, vfprint_
	j	do_printf_	# tail call
	.end	vfprintf

	.globl  vprintf
	.ent	vprintf
vprintf:
	.mask   0x00000000, 0
	.frame  $sp, 0, $31
	la	$15, vprint_
	j	do_printf_	# tail call
	.end	vprintf

	.globl  vsprintf
	.ent	vsprintf
vsprintf:
	.mask   0x00000000, 0
	.frame  $sp, 0, $31
	la	$15, vsprint_
	j	do_printf_	# tail call
	.end	vsprintf



	
