/****************************************************************************
*****************************************************************************

Parallel Architecture Simulator
Eric A. Brewer  and  Chris N. Dellarocas
Laboratory for Computer Science
Massachusetts Institute of Technology

Module:  Augment -- Load C library symbols

Description:
    Loads a symbol for each C library routine

Last Modified: 8-27-91  (eab)

Global Functions:
    void LoadMissingLibc()
        Loads the symbol table with the names of non cycle-counted
	library routines.  Assumes symbol table has been initialized.

Global Variables:
    none

****************************************************************************
*   Copyright 1991                                                       
*   Eric A. Brewer  and  Chris N. Dellarocas                             
*   Massachusetts Institute of Technology                                
*                                                                        
*   Permission to use, copy, modify, and distribute this program         
*   for any purpose and without fee is hereby granted, provided          
*   that this copyright and permission notice appear on all copies       
*   and supporting documentation, the name of M.I.T. not be used         
*   in advertising or publicity pertaining to distribution of the        
*   program without specific prior permission, and notice be given       
*   in supporting documentation that copying and distribution is         
*   by permission of M.I.T.  M.I.T. makes no representations about       
*   the suitability of this software for any purpose.  It is pro-        
*   vided "as is" without express or implied warranty.		          
*****************************************************************************
****************************************************************************/

#include "lex.h"
const char *InsertSymbol(const char *sym, int kind);


/* INSTALLATION NOTE:
 *   Don't worry if the compiler complains about being unable to optimize
 *   this procedure -- it doesn't matter.
 */

void LoadMissingLibc()
{

#include "libc/missing.h"

#include "libm/missing.h"

}



