package main

import (
  "fmt"
  "time"
)


func prefix(first int, in <-chan int, out chan<- int) {
  v := first
  for {
    out <- v
    v = <-in
  }
}

func succ(in <-chan int, out chan<- int) {
  for {
    v := <-in
    out <- v + 1
  }
}

func seq_delta(in <- chan int, out0, out1 chan<- int) {
  for {
    n := <-in
    out0 <- n
    out1 <- n
  }
}

func consume(n int64, c <-chan int) {
  for i := int64(0); i < n; i++ {
    <-c
  }
}

func main() {
  a := make(chan int)
  b := make(chan int)
  c := make(chan int)
  d := make(chan int)

  go prefix (0, b, a)
  go seq_delta (a, c, d)
  go succ (c, b)

  fmt.Println("Commstime starting ...")
  var n_loops int64
  n_loops = 1000000
  // warm-up
  consume (16, d)
  start := time.Now()
  consume (n_loops, d)
  nanos := time.Since(start).Nanoseconds()
  tpl := nanos/n_loops
  fmt.Printf("Time: %dns, time per loop: %dns, context switch: %dns\n", nanos, tpl, tpl / 4)
}
