package main

import (
	"encoding/json"
	"fmt"
	"io"
	"io/ioutil"
	"log"
	"net/http"
	"strings"
	"time"
)

type Lang struct {
	Name string
	Year int
	URL  string
}

var jsonLines = `
	{"Name": "Python", "Year": 1991, "URL": "http://python.org/"}
	{"Name": "Ruby", "Year": 1995, "URL": "http://www.ruby-lang.org/en/"}
	{"Name": "Scala", "Year": 2003, "URL": "http://www.scala-lang.org/"}
	{"Name": "Go", "Year": 2009, "URL": "http://golang.org/"}
`

func do(jsonLines string, f func(Lang)) {
	dec := json.NewDecoder(strings.NewReader(jsonLines))
	for {
		var lang Lang
		err := dec.Decode(&lang)
		if err != nil {
			if err == io.EOF {
				break
			}
			log.Fatal(err)
		}
		f(lang)
	}
}

func countWebpageContent(name, url string) {
	start := time.Now()
	r, err := http.Get(url)
	if err != nil {
		fmt.Printf("%s: %s\n", name, err)
		return
	}
	// copy the content to a black hole, counting the bytes copied
	n, _ := io.Copy(ioutil.Discard, r.Body)
	r.Body.Close()
	fmt.Printf("%s %d [%.2fs]\n", name, n, time.Since(start).Seconds())
}

func main() {
	start := time.Now()
	do(jsonLines, func(lang Lang) {
		go countWebpageContent(lang.Name, lang.URL) //---------- added 'go'
	})
	fmt.Printf("%.2fs total\n", time.Since(start).Seconds())
	time.Sleep(10 * time.Second) //---------- added a rubbish sleep
}
