package main

import (
	"encoding/json"
	"encoding/xml"
	"fmt"
	"io"
	"log"
	"strings"
)

type Lang struct {
	Name string
	Year int
	URL  string
}

var jsonLines = `
	{"Name": "Python", "Year": 1991, "URL": "http://python.org/"}
	{"Name": "Ruby", "Year": 1995, "URL": "http://www.ruby-lang.org/en/"}
	{"Name": "Scala", "Year": 2003, "URL": "http://www.scala-lang.org/"}
	{"Name": "Go", "Year": 2009, "URL": "http://golang.org/"}
`

func do(jsonLines string, f func(Lang)) {
	dec := json.NewDecoder(strings.NewReader(jsonLines))
	for {
		var lang Lang
		err := dec.Decode(&lang)
		if err != nil {
			if err == io.EOF {
				break
			}
			log.Fatal(err)
		}
		f(lang)
	}
}

func main() {
	do(jsonLines, func(lang Lang) {
		fmt.Printf("%#v\n", lang)
	})

	do(jsonLines, func(lang Lang) {
		xml, err := xml.MarshalIndent(lang, "", "  ")
		if err != nil {
			log.Fatal(err)
		}
		fmt.Printf("%s\n", xml)
	})
}
