#!/usr/local/bin/perl
#
# fixilist.pl
#
# Copyright (C) 1992 David Beckett.
#
# Takes the output of 'ilist -p <library>' and converts it to a readable
# form, omitting duplicated library names.  Useful for constructing
# documents about libraries.  Ilist is the INMOS lister tool, capable
# of reading TCOFF (Transputer COFF) libraries.
#
  
# The maximum line length to use
  $maxlength = 78;
# Bits of text that are inserted at start and end of lines
$lineprefix = "";
$linesuffix = "";
# Bits of text inserted before and after output of a procedure
$procprefix = "";
$procsuffix = "";
# Bits of text inserted before and after output of a function
$funcprefix = "";
$funcsuffix = "";

%functions = ();
%procs = ();

while (<>)
{
  chop;
  next if /^INDEX ENTRY/;
  next if /^ws:/;
  next if /^:/;
  
# PROC <name>([VAL] <type> <name>,
# [VAL] <type> <name>,
# [VAL] <type> <name>)
#
# <type> FUNCTION <name>([VAL] <type> <name>,
# [VAL] <type> <name>,
# [VAL] <type> <name>)
  
  if (/^PROC/) 
    {
      $line = $_;
      $output = $procprefix . $lineprefix;
      $name = $line;
      
      $name =~ s/^PROC ([A-Za-z.%]*)\(.*/\1/;
      if (!$procs{$name} && (index($name,'%')==-1)) # Not in already and valid
	{
	  $procs{$name}=1;
	  $indent=index($line,'(')+1;
	  if (index($line, ')') > 0)
	    {
	      $output = $output . $line . $linesuffix;
	    }
	  else
	    {
	      do
		{
		  $_ = <STDIN>;
		  chop;
		  if ((length($line) + length($_) + 1) < $maxlength) 
		    {
		      $line = $line . ' ' . $_;
		    }
		  else
		    {
		      $output = $output . $line . $linesuffix . "\n";
		      $line = $lineprefix . " " x $indent . $_;
		    }
		}
	      until ( /\)$/ );
	      $output=$output . $line . $linesuffix;
	    }
	  
	  do
	    {
	      $_ = <STDIN>;
	    }
	  until (/:/);
	  
	  print $output . "\n" . $procsuffix;
  
	}
      else # Drop
	{
	  chop while(<STDIN> !~ /:/);
	}
  
    }
  elsif (/ FUNCTION /)
    {
      $line = $_;
      $output = $funcprefix . $lineprefix;
      $name = $line;
      
      $name =~ s/.* FUNCTION ([A-Za-z.%]*)\(.*/\1/;
      if (!$functions{$name} && (index($name,'%')==-1)) # Not in already and OK
	{
	  $functions{$name}=1;
	  $indent=index($line,'(')+1;
	  if (index($line, ')') > 0)
	    {
	      $output = $output . $line . $linesuffix;
	    }
	  else
	    {
	      do
		{
		  $_ = <STDIN>;
		  chop;
		  if ((length($line) + length($_) + 1) < $maxlength) 
		    {
		      $line = $line . ' ' . $_;
		    }
		  else
		    {
		      $output = $output . $line . $linesuffix . "\n";
		      $line = $lineprefix . " " x $indent . $_;
		    }
		}
	      until ( /\)$/ );
	      $output=$output . $line . $linesuffix;
	    }
	  
	  do
	    {
	      $_ = <STDIN>;
	    }
	  until (/:/);
	  
	  print $output . "\n" . $funcsuffix;
  
	}
      else # Drop
	{
	  chop while(<STDIN> !~ /:/);
	}
    }
  else
    {
      die "Unknown entry line - ",$_;
    }
  
}
exit 0;
