/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : GPMIMD ESPRIT P5404
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Virtual processor interface module definitions
||@(#)   System : UBIK
||@(#) Filename : vpmain.h
||@(#)  Version : 1.16
||@(#)     Date : 6/16/92
\*@(#)====================================================*/
/*}}}*/

/*{{{  UBIK channel block*/
#define OverLength_p (-1)
#define NotLength_p  (-2)
#define NeverQueue_p (UCB *)(-1)

typedef struct UCB UCB ;

struct UCB
{
  Channel id ;
  UCB     *next ;
  PORT    *port ;
  ORB     orb ;
  BYTE    *buffer ;
  int     readlen ;
} ;

typedef struct
{
  PORT in_port ;
  UCB  in_ucb ;
  PORT out_port ;
  UCB  out_ucb ;
  BYTE packet[UPR_MAX_PKT_SIZE] ;
} VCPAIR ;
/*}}}*/

/*{{{  typedef struct SERVER*/
typedef struct
{
  WDESC wdesc ;
  UCB  *in ;
  UCB  *out ;
  UCB  *head ;
  UCB  *tail ;
} SERVER ;
/*}}}*/

/*{{{  typedef struct CLIENT*/
typedef struct
{
  semaphore sema ;
  BOOL bound ;
  UCB  in ;
  UCB  out ;
} CLIENT ;
/*}}}*/

/*{{{  typedef struct VPFUNC*/
typedef struct
{
  int  (*VarLenIn)() ;
  void (*VarLenOut)() ;
  int  (*NewVCE)() ;
  void (*ConnectVCE)() ;
  void (*FreeVC)() ;
} VPFUNC ;
/*}}}*/

typedef struct
{
  int     proc_id ;
  int     num_procs ;
  void   *gsb ;
  SERVER  server ;
  CLIENT *client ;
  int     server_port_base ;
  int     client_port_base ;
  VPFUNC  vpfunc ;
  int    *children ;
  int     parent ;
} VPI_GLOBALS ;

EXTERN VPI_GLOBALS vpi_globals ;

