/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : GPMIMD ESPRIT P5404
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Internal variable length channel i/o
||@(#)   System : VPI
||@(#) Filename : schan.c
||@(#)  Version : 1.3
||@(#)     Date : 6/1/92
\*@(#)====================================================*/
/*}}}*/

#include "vcr.h"
#include "vpi.h"
#include "vpmain.h"
#include "schan.h"

/* These routines implement internal variable length i/o similar to T9000s :
     Zero length messages work.
     ALTs are not supported.
     Communicating processes must have the same priority or the
     non-pre-emption of the low priority process must be guaranteed.
     The compiler must not generate "j"s for the two routines.
     Workspace zero is a temporary register to hold the message length.
*/
   
/*{{{  PUBLIC void SoftVarLenOut(Channel *c, void *message, int length)*/
PUBLIC void SoftVarLenOut(Channel *c, void *message, int length)
{
  struct
  {
    int  workspace_zero ;
    int *wptr ;
  } local ;


  if (*c == NotProcess_p)
  {
    *((void **) &local-3)  = message ;
    local.workspace_zero = length ;
    ProcDesc(c) ;
    ProcSleep() ;
    return ;
  }
  else
  {
    local.wptr = (int *) ((int) *c & (-2)) ;
    if (*local.wptr < length)
      {
        *local.wptr = OverLength_p ;
        ProcAwaken(*c) ;
        *c = NotProcess_p ;
        return ;
      }
    else
      {
        if (length > 0)
          RawMove(message,(void *) *(local.wptr-3), length) ;
        *local.wptr = length ;
        ProcAwaken(*c) ;
        *c = NotProcess_p ;
        return ;
      }
  }
}

/*}}}*/
/*{{{  PUBLIC int  SoftVarLenIn (Channel *c, void *message, int length)*/
PUBLIC int  SoftVarLenIn (Channel *c, void *message, int length)
{
  struct
  {
    int  workspace_zero ;
    int *wptr ;
  } local ;

  if (*c == NotProcess_p)
  {
    *((void **) &local-3)  = message ;
    local.workspace_zero = length ;
    ProcDesc(c) ;
    ProcSleep() ;
    return(local.workspace_zero) ;
  }
  else
  {
    local.wptr = (int *) ((int) *c & (-2)) ;
    if (*local.wptr > length)
      {
        *local.wptr = OverLength_p ;
        ProcAwaken(*c) ;
        *c = NotProcess_p ;
        return(OverLength_p) ;
      }
    else
      {
        if (*local.wptr > 0)
          RawMove((void *) *(local.wptr-3), message, *local.wptr) ;
        ProcAwaken(*c) ;
        *c = NotProcess_p ;
        return(*local.wptr) ;
      }
  }
}
/*}}}*/

