/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Virtual channels show functions
||@(#)   System : VCR
||@(#) Filename : vshow.c
||@(#)  Version : 2.3
\*@(#)====================================================*/
/*}}}*/

#include <stdio.h>
#include <stdlib.h>

#include "vcr.h"

/*{{{  PUBLIC void ViewVCB (VCB *vcb)*/
PUBLIC void ViewVCB (VCB *vcb)
{
  printf("******* VCB at %08x **********\n",(int) vcb);
  printf("direction : %s\n", (vcb->buffer==NULL) ? "out" : "in") ;
  printf("type      : %s\n", (vcb->dcb==NULL) ? "static" : "dynamic") ;
  printf("header    : D%0d-P%0d\n",HdrDestn(&vcb->orb.header), HdrPort(&vcb->orb.header));
  printf("id        : %x\n", (int) vcb->id) ;
  printf("port at   : %x\n", (int) vcb->port) ;
  printf("input_len : %d\n", vcb->port->space) ;
  printf("input_ptr : %x\n", (int) vcb->port->buffer) ;
  printf("pre flag  : %s\n", (vcb->port->do_pre  == FALSE) ? "false" : "true") ;
  printf("post flag : %s\n", (vcb->port->do_post == FALSE) ? "false" : "true") ;
  
  if (vcb->buffer != NULL)
  {
    int f ;
    
    for (f=0;f<UPR_MAX_PKT_SIZE;f++)
    {
      printf("%4x  ",vcb->buffer[f]) ;
      if ((f % 8)==7) printf("\n") ;
    }
  }

  printf("************************************\n");
}
/*}}}*/

/*{{{  PUBLIC void ViewSCDB(SCDB* scdb)*/
PUBLIC void ViewSCDB(SCDB* scdb)
{
  printf("******* SCDB at %08x **********\n",(int) scdb);
  printf("* Next       : %08x\n",(int) scdb->next);
  printf("* Work space : %d\n",scdb->wsp_size);
  printf("* Vec space  : %d\n",scdb->vsp_size);
  printf("* Static size: %d\n",scdb->static_size) ;
  printf("* EP Offset  : %d\n",scdb->ep_offset);
  printf("* Code size  : %d\n",scdb->code_size);
  printf("* Code Ptr   : %08x\n",(int) scdb->code);
  printf("* Filename   : %s\n",scdb->filename);
  printf("* Symbol     : %s\n",scdb->symbol);
  printf("* Patches    : ");
  {
      PDB *patch= scdb->patch ;
      while (patch!=NULL)
      {
        printf("%10s %15s\n*            : ",patch->filename,patch->symbol);
        patch = patch->next;
      }
      printf("END\n");
  }
  printf("************************************\n");
}
/*}}}*/

/*{{{  PUBLIC void ViewPBLOCK (PBLOCK *pblock)*/
PUBLIC void ViewPBLOCK (PBLOCK *pblock)
{
  int i, j ;

  printf("******* PBLOCK at %x **********\n",(int) pblock);
  printf("target : %d\n", pblock->target) ;

  for (i=0;i<num_fields;i++)
  {
    printf("field %3d, start %3d, current %3d\n", i, pblock->field[i].start, pblock->field[i].current) ;

    if (i != (num_fields-1))
    {
      int tab = 0 ;

      if (FIELD_DIR(i) > 0)
        for (j=pblock->field[i].start; j<pblock->field[i].current; j++)
        {
          printf("  %10d", pblock->pb[j]) ;
          if (++tab % 6 == 6) printf("\n") ;
        }
      else
        for (j=pblock->field[i].current; j<pblock->field[i].start; j++)
        {
          printf("  %10d", pblock->pb[j]) ;
          if (++tab % 6 == 6) printf("\n") ;
        }
      
      printf("\n") ;
    }
  }

  printf("*******************************\n") ;
}


/*}}}*/
    
  
