/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : System remote procedure call routines
||@(#)   System : vcr
||@(#) Filename : vrpc.c
||@(#)  Version : 2.2
||@(#)     Date : 8/14/91
\*@(#)====================================================*/
/*}}}*/

#include <stdiored.h>
#include <stdlib.h>
#include <string.h>

#include "vcr.h"
#include "vchan.h"
#include "vmove.h"
#include "vrpc.h"

/*{{{  statics*/
static char *_FILE_ = __FILE__ ;

static int stub_code [stub_size] = {
   0xFB214460,   /* LDC -12   Offset to iptr state  */
                 /* LDPI                            */
   0xFB214460,   /* LDC -12   Offset to wptr state  */
                 /* LDPI                            */
   0xF0FC2330,   /* LDNL 0    Get wptr              */
                 /* GAJW                            */
                 /* REV                             */
   0x0000F630    /* LDNL 0    Get iptr              */
                 /* GCALL                           */
} ;
/*}}}*/

/*{{{  PRIVATE void CallDynamicOccam*/
PRIVATE void CallDynamicOccam(int *wptr, char *iptr)
{
  int stub[state_size+stub_size] ;

  AsmMove (stub_code, &stub[state_size], sizeof(int)*stub_size) ;

  __asm {
          /*{{{  retain caller iptr*/
          ldlabeldiff done-here ;
          ldpi ;
          here: st stub[iptr_state] ;
          /*}}}*/
          /*{{{  retain caller wptr */
          ldlp 0 ;
          st stub[wptr_state] ;
          /*}}}*/
          /*{{{  force return to stub*/
          ld &stub[state_size] ;
          st *wptr ;
          /*}}}*/
          /*{{{  call code (at current priority)*/
          ld iptr ;
          ld wptr ;
          gajw ;
          rev ;
          gcall ;
          done: ;
          /*}}}*/
        } ;   
}
/*}}}*/

/*{{{  PUBLIC void DynamicOccam (PBLOCK *pblock, int *vs, SCDB *scdb)*/
PUBLIC void DynamicOccam (PBLOCK *pblock, int *vs, SCDB *scdb)
{
  int *pb = pblock->pb ;
  
  /*{{{  relocate pointers*/
  {
    int i ;
    for (i=pblock->field[relocs_f].start;i<pblock->field[relocs_f].current;i++)
      pb[pb[i]] = pb[pb[i]] * sizeof(int) + (int) pb ;
  }
  /*}}}*/
  /*{{{  insert vec space pointer in next available parameter slot*/
  pb[pblock->field[params_f].current] = (int) vs ;
  /*}}}*/
  /*{{{  call dynamic occam code*/
  /* note wptr is params pointer adjusted by iptr slot */
  
  CallDynamicOccam (&pb[pblock->field[params_f].start - 1], scdb->code+scdb->ep_offset) ; 
  /*}}}*/
}  
/*}}}*/

/*{{{  PUBLIC void *Malloc (int size)*/
PUBLIC void *Malloc (int size)
{
  return(Malloc(size)) ;
}
/*}}}*/
/*{{{  PUBLIC void Free (void *pointer)*/
PUBLIC void Free (void *pointer)
{
  free(pointer) ;
}
/*}}}*/
  
/*{{{  PUBLIC void RPC_PlacedRun   (PBLOCK *pblock, char *filename)*/
PUBLIC void RPC_PlacedRun   (PBLOCK *pblock, char *filename)
{
  DUPLEX_VC vc ;
  int sizes[2] ;
  int *pb = pblock->pb ;

  if (vcr_globals.proc_id == pblock->target)
    /*{{{  internal RPC*/
    {
      SCDB *scdb ;
      int  total_size ; /* in bytes */
      int  *ws, *rpb, *vs ;
    
      /*{{{  get code*/
      scdb = RPC_LoadCode (filename) ;
      
      if (scdb->patch != NULL)
        Exception(UPR_error,_FILE_,__LINE__,"Cannot RPC unresolved code") ;
      /*}}}*/
      /*{{{  allocate and segregate thread's workspace*/
      {
        total_size = (scdb->wsp_size + iptr_size + pblock->field[varptrs_f].start + scdb->vsp_size)*sizeof(int) ;
      
        if ((ws = (int *) malloc (total_size)) == NULL)
          Exception(UPR_error,_FILE_,__LINE__,"Out of heap whilst allocating RPC workspace") ;
      
        rpb = (int *) (ws + scdb->wsp_size + iptr_size) ;
        vs =  (int *) (rpb + pblock->field[varptrs_f].start) ;
      }
      /*}}}*/
      /*{{{  transfer parameter block data*/
      AsmMove (pb, rpb, pblock->field[varptrs_f].start * sizeof(int)) ;
      pblock->pb = rpb ;
      /*}}}*/
      
      DynamicOccam (pblock, vs, scdb) ;
      
      /*{{{  if explicit, return local channels*/
      if (pblock->move == explicit_move)
      {
        int i ;
      
        for (i=pblock->field[chans_f].start;i<pblock->field[chans_f].current;i++)
          DVC_ReturnChannel ((VCB *) (pb[i] & virtual_mask)) ;
      }
      /*}}}*/
      /*{{{  recover var data field*/
      AsmMove (&rpb[pblock->field[vardata_f].start],
               &pb[pblock->field[vardata_f].start],
               (pblock->field[vardata_f].current - pblock->field[vardata_f].start) *sizeof(int)) ;
      /*}}}*/
      /*{{{  clean up*/
      pblock->pb = pb ;
      free (ws) ;
      /*}}}*/
    }
    /*}}}*/
  else
    /*{{{  external RPC*/
    {  
      VCR_LaunchServer (&vc, pblock->target, svr_rpc) ;
    
      /*{{{  if implicit, move channels and record in pb*/
      if (pblock->move == implicit_move)
      {
        int i ;
        for (i=pblock->field[chans_f].start ;
             i<pblock->field[chans_f].current ; i+=couple)
          pb[pb[i+1]] = (int) DVC_MoveChannel (pblock->target, (VCB *) (pb[i] & virtual_mask)) | virtual_bit ;
      }
      /*}}}*/
      /*{{{  send filename and pblock*/
      sizes[0] = strlen(filename) + 1;
      sizes[1] = pblock->field[varptrs_f].start * sizeof(int) ;
      
      VirtualOut (vc.out, sizes, 2*sizeof(int)) ;
      VirtualOut (vc.out, filename, sizes[0]) ;
      VirtualOut (vc.out, pblock,   sizes[1]+sizeof(PBLOCK)) ;
      /*}}}*/
      /*{{{  receive var data field*/
      VirtualIn  (vc.in, &pblock->pb[pblock->field[vardata_f].start],
       (pblock->field[vardata_f].current - pblock->field[vardata_f].start) *sizeof(int)) ;
      /*}}}*/
      /*{{{  if implicit, restore local channels in pb*/
      if (pblock->move == implicit_move)
      {
        int i ;
        for (i=pblock->field[chans_f].start ;
             i<pblock->field[chans_f].current ; i+=couple)
          pb[pb[i+1]] = pb[i] ;
      }
      /*}}}*/
      
      VCB_Free (vc.in) ;
      VCB_Free (vc.out) ;
    }
    /*}}}*/
}
/*}}}*/
