/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : VCR local packet library
||@(#)   System : VCR
||@(#) Filename : vpktio.c
||@(#)  Version : 2.2
||@(#)     Date : 10/15/92
\*@(#)====================================================*/
/*}}}*/

#include <stdlib.h>

#include "vcr.h"

static char *_FILE_ = __FILE__ ;

/* These functions must be called at HI priority */

/*{{{  PRIVATE sub_enqueue (ORB *orb)*/
PRIVATE sub_enqueue (ORB *orb)
{    
  LOLB *lolb = &vcr_globals.lolb ;
  OQB  *oqb  = &lolb->oqb ;

  orb->list =  (ORB *) NULL ;

  if (oqb->h == (ORB *) NULL)
  {
    if (oqb->t == (ORB *) NULL)
      /*{{{  make first entry*/
      {
        oqb->h = orb ;
        oqb->t = orb ;
      }
      /*}}}*/
    else
      Exception(UPR_fatal, _FILE_, __LINE__, "Invalid QQB State") ;
  }
  else
    /*{{{  append ORB to OQB*/
    {
      oqb->t->list = orb ;
      oqb->t = orb ;
    }
    /*}}}*/

  if (lolb->active == FALSE)
    /*{{{  run output handler*/
    {
      lolb->active = TRUE ;
      ProcAwaken( lolb->wdesc ) ;
    }
    /*}}}*/
}

/* Must be called at high priority. On entry header contains correct
   length of first packet. ORB contains total length of buffer to send.
*/
   
/*}}}*/

/*{{{  PUBLIC void VCR_Enqueue_BK (ORB *orb)*/
PUBLIC void VCR_Enqueue_BK (ORB *orb)
{
  if (HdrDestn(&orb->header) == vcr_globals.proc_id)
  {
    orb->bffrlen = HdrLength (&orb->header) ;
    ProcDesc(&(orb->wdesc)) ;
    sub_enqueue(orb) ;
    ProcSleep() ;
  }
  else
    UPR_Enqueue_BK (orb) ;
}
/*}}}*/
/*{{{  PUBLIC void VCR_Enqueue_NBK(ORB *orb)*/
PUBLIC void VCR_Enqueue_NBK(ORB *orb)
{
  if (HdrDestn(&orb->header) == vcr_globals.proc_id)
  {
    orb->bffrlen = HdrLength (&orb->header) ;
    orb->wdesc = NULL ;
    sub_enqueue(orb) ;
  }
  else
    UPR_Enqueue_NBK (orb) ;
}
/*}}}*/

/*{{{  PUBLIC void VCR_MultipleEnqueue_BK (ORB *orb, int length)*/
PUBLIC void VCR_MultipleEnqueue_BK (ORB *orb, int length)
{
  if (HdrDestn(&orb->header) == vcr_globals.proc_id)
  {  
    orb->bffrlen = length ;
    HdrModLength (min(length,UPR_MAX_PKT_SIZE),&orb->header) ;

    ProcDesc(&(orb->wdesc)) ;
    sub_enqueue(orb) ;
    ProcSleep() ;
  }
  else
    UPR_MultipleEnqueue_BK (orb,length) ;
}
/*}}}*/
/*{{{  PUBLIC void VCR_MultipleEnqueue_NBK(ORB *orb, int length)*/
PUBLIC void VCR_MultipleEnqueue_NBK(ORB *orb, int length)
{
  if (HdrDestn(&orb->header) == vcr_globals.proc_id)
  {
    orb->bffrlen = length ;
    HdrModLength (min(length,UPR_MAX_PKT_SIZE),&orb->header) ;

    orb->wdesc = NULL ;
    sub_enqueue(orb) ;
  }
  else
    UPR_MultipleEnqueue_BK (orb,length) ;
}
/*}}}*/
