/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Move/Create Dynamic Channel Primitives
||@(#)   System : VCR
||@(#) Filename : vmove.c
||@(#)  Version : 2.4
||@(#)     Date : 4/15/92
\*@(#)====================================================*/
/*}}}*/

#include <stdiored.h>
#include <stdlib.h>
#include "vcr.h"
#include "vchan.h"
#include "vmove.h"
#include "vpktio.h"

char *_FILE_ = __FILE__ ;

/*{{{  PUBLIC void DVC_InitDCB( DCB *dcb, HEADER *other )*/
PUBLIC void DVC_InitDCB( DCB *dcb, HEADER *other )
{
  dcb->orb.bffr = (BYTE*) (&(dcb->dcp)) ;
  dcb->orb.list = InputServiced_p ;
  dcb->dm_orb.bffr = (BYTE*) (&(dcb->dm_dcp)) ;
  dcb->dm_orb.list = InputServiced_p ;
  dcb->state = dvc_ready ;
  HdrCopy (other, &dcb->other) ;
  HdrModLength(NULL_HEAD_L,&(dcb->parent));
  HdrModLength(NULL_HEAD_L,&(dcb->child));
  dcb->restart = NotProcess_p ;
}
/*}}}*/
  
/*{{{  PRIVATE void DVC_Request( DCB *dcb, int local_id, int remote_proc, DIRECTION way)*/
PRIVATE void DVC_Request( DCB *dcb, int local_id, int remote_proc, DIRECTION way)
{
  dcb->dcp.tag = dvc_request;
  {
    DVC_REQUEST *dvc_request = &(dcb->dcp.p.dvc_request) ;
    dvc_request->way = way ;
    dvc_request->proc_id = vcr_globals.proc_id ;
    dvc_request->port_id = local_id ;
  }

  ProcDesc(&(dcb->restart)) ;
  dcb->orb.bffr = (BYTE*) &dcb->dcp ;
  HdrBuild (remote_proc, vcr_globals.vcr_ctrl_port_id, sizeof(DVC_REQUEST)+ctrl_pkt_ovrhd, &(dcb->orb.header)) ;

  UPR_Enqueue_NBK (&(dcb->orb)) ;
  ProcSleep();
}
/*}}}*/

/*{{{  PUBLIC void DVC_CreateChannelOut(VCB **local_out,VCB **remote_in, int remote)*/
PUBLIC void DVC_CreateChannelOut(VCB **local_out,VCB **remote_in, int remote)
{
  PORT *port_out;
  int out_id ;
  int in_id ;
  DCB *dcb ;

  /*{{{  check remote valid*/
  if ((remote < 0) || (remote >= vcr_globals.num_nodes))
    Exception(UPR_error,__FILE__,__LINE__,"Create channel to invalid destination") ;
  /*}}}*/
  
  if ((*local_out = (VCB*) malloc (sizeof(VCB)+sizeof(DCB))) == NULL)
    Exception (UPR_error, _FILE_, __LINE__, "Out of heap space whilst allocating vcb");

  port_out = PortAlloc (VCR_OutPreAction, TRUE, VCR_OutPostAction, FALSE, *local_out);
      
  out_id = port_out->id ;

  dcb = (DCB *)( ((char*) *local_out) + sizeof(VCB));
  (*local_out)->dcb = dcb;

  if (vcr_globals.proc_id == remote)
    /*{{{  internal DVC*/
    {
      PORT *port ;
      DCB *other_dcb ;
    
      if ((*remote_in = (VCB*) malloc(sizeof(VCB)+UPR_MAX_PKT_SIZE+sizeof(DCB)))==NULL)
        Exception(UPR_error,_FILE_,__LINE__,"DVCB malloc failed");
      port=PortAlloc (VCR_InPreAction,TRUE,VCR_InPostAction,FALSE,*remote_in);
      other_dcb = (DCB*)( ((char*) *remote_in)+UPR_MAX_PKT_SIZE+sizeof(VCB));
      VCB_Init(*remote_in,port,(BYTE*) ((*remote_in)+1), other_dcb, remote,out_id);
      DVC_InitDCB( other_dcb,&((*remote_in)->orb.header));
      in_id = port->id ;    
    
      VCB_Init (*local_out,  port_out, NULL, dcb, remote, in_id) ;
      DVC_InitDCB(dcb, &((*local_out)->orb.header));
    }
    /*}}}*/
  else
    /*{{{  external DVC*/
    {
      int priority ;
      ProcGetPRI(&priority) ;
    
      if (priority==PROC_LOW) ProcToHI() ;
      /*{{{  critical code section*/
      DVC_Request( dcb, out_id, remote, input_d ) ;
      
      if (dcb->dcp.tag != dvc_reply)
        Exception(UPR_error,_FILE_,__LINE__,"Did not receive reply to dynamic channel request");
        
      in_id = dcb->dcp.p.dvc_reply.port_id;
      *remote_in = dcb->dcp.p.dvc_reply.vc_ptr;
      
      VCB_Init (*local_out,  port_out, NULL, dcb, remote, in_id) ;
      DVC_InitDCB(dcb, &((*local_out)->orb.header));
      
      /*}}}*/
      if (priority==PROC_LOW) ProcToLO() ;
    }
    /*}}}*/

  /*{{{  debug CreateOut*/
  #ifdef DVC_DEBUG
  {
    char s[100];
    sprintf(s,"Created DVC_Out (%d:%d -> %d:%d)",vcr_globals.proc_id,out_id,HdrDestn(&(*local_out)->orb.header),HdrPort(&(*local_out)->orb.header));
    Exception(UPR_warning,_FILE_,__LINE__,s);
  }
  #endif
  /*}}}*/
}
/*}}}*/
/*{{{  PUBLIC void DVC_CreateChannelIn(VCB **local_in,VCB **remote_out, int remote)*/
PUBLIC void DVC_CreateChannelIn(VCB **local_in,VCB **remote_out, int remote)
{
  PORT *port_in;
  int out_id ;
  int in_id ;
  DCB *dcb ;

  /*{{{  check remote valid*/
  if ((remote < 0) || (remote >= vcr_globals.num_nodes))
    Exception(UPR_error,__FILE__,__LINE__,"Create channel to invalid destination") ;
  /*}}}*/
  
  if ((*local_in = (VCB*) malloc (sizeof(VCB)+UPR_MAX_PKT_SIZE+sizeof(DCB))) == NULL)
    Exception (UPR_error, _FILE_, __LINE__, "Out of heap space whilst allocating vcb");

  port_in = PortAlloc (VCR_InPreAction, TRUE, VCR_InPostAction, FALSE, *local_in);
      
  in_id = port_in->id ;

  dcb = (DCB *)( ((char*) *local_in) + UPR_MAX_PKT_SIZE + sizeof(VCB));
  (*local_in)->dcb = dcb;

  if (vcr_globals.proc_id==remote)
    /*{{{  internal DVC*/
    {
      PORT *port ;
      DCB *other_dcb ;  
      if ((*remote_out = (VCB*) malloc(sizeof(VCB)+sizeof(DCB)))==NULL)
        Exception(UPR_error,_FILE_,__LINE__,"DVCB malloc failed");
      port=PortAlloc (VCR_OutPreAction,TRUE,VCR_OutPostAction,FALSE,*remote_out);
      other_dcb = ( DCB*) ((*remote_out)+1 ) ;
      VCB_Init(*remote_out,port,NULL, other_dcb , remote,in_id);
      DVC_InitDCB( other_dcb, &((*remote_out)->orb.header));
      out_id = port->id ;    
    
      VCB_Init (*local_in,port_in, (BYTE*) ((*local_in)+1), dcb, remote, out_id) ;
      DVC_InitDCB(dcb, &((*local_in)->orb.header));
    }
    /*}}}*/
  else
    /*{{{  external DVC*/
    {
      int priority ;
      ProcGetPRI(&priority) ;
      if (priority==PROC_LOW) ProcToHI() ;
      /*{{{  critical code section*/
      DVC_Request( dcb, in_id, remote, output_d ) ;
      
      if (dcb->dcp.tag != dvc_reply)
        Exception(UPR_error,_FILE_,__LINE__,"Did not receive reply to dynamic channel request");
        
      out_id = dcb->dcp.p.dvc_reply.port_id;
      *remote_out = dcb->dcp.p.dvc_reply.vc_ptr;
      
      VCB_Init (*local_in,  port_in, (BYTE*) ((*local_in)+1), dcb, remote, out_id) ;
      DVC_InitDCB(dcb, &((*local_in)->orb.header));
      /*}}}*/
      if (priority==PROC_LOW) ProcToLO() ;
    }
    /*}}}*/

  /*{{{  debug CreateIn*/
  #ifdef DVC_DEBUG
  {
    char s[100];
    sprintf(s,"Created DVC_In (%d:%d <- %d:%d)",vcr_globals.proc_id,in_id,HdrDestn(&(*local_in)->orb.header),HdrPort(&(*local_in)->orb.header));
    Exception(UPR_warning,_FILE_,__LINE__,s);
  }
  #endif
/*}}}*/

}
/*}}}*/
/*{{{  PUBLIC void DVC_DestroyChannelEnd(VCB *vcb)*/
PUBLIC void DVC_DestroyChannelEnd(VCB *vcb)
{
  if (vcb->dcb==NULL)
    Exception(UPR_error,_FILE_,__LINE__,"Tried to destroy static channel");
  else
    VCB_Free(vcb);
}
/*}}}*/
        
/*{{{  PUBLIC VCB *DVC_MoveChannel (int target, VCB *vcb)*/
PUBLIC VCB *DVC_MoveChannel (int target, VCB *vcb)
{
  DCB *dcb = vcb->dcb ;
  int priority;

  /*{{{  check target valid*/
  if ((target < 0) || (target >= vcr_globals.num_nodes))
    Exception(UPR_error,__FILE__,__LINE__,"Move channel to invalid destination") ;
  /*}}}*/
  
  /*{{{  ensure Hi priority*/
  ProcDesc(&dcb->restart);
  ProcGetPRI(&priority);
  if (priority==PROC_LOW) ProcToHI();
  /*}}}*/
  
  if (dcb == NULL)
    Exception(UPR_error,_FILE_,__LINE__,"Attempted move on static channel");

  /*{{{  debug Move*/
  #ifdef DVC_DEBUG
  {
    char s[100];
    sprintf(s,"Move [ %d -> %d ]",vcr_globals.proc_id,target);
    Exception(UPR_warning,_FILE_,__LINE__,s);
  }
  #endif
  /*}}}*/

  if (dcb->state == dvc_ready)
    /*{{{  MV1:*/
    {
      dcb->state = dvc_finding ;
      HdrModLength(NULL_HEAD_L, &dcb->child);     
      /*{{{  SEND Offload ; make_way ; src_p ; src_c ; other_p ; other_c*/
      {
        if (dcb->orb.list != InputServiced_p)
          Exception(UPR_error,_FILE_,__LINE__,"ORB in use upon DVC_MoveChannel") ;
          
        dcb->dcp.tag = dvc_offload ;
        if (vcb->buffer == NULL)
          dcb->dcp.p.dvc_offload.make_way = output_d;
        else
          dcb->dcp.p.dvc_offload.make_way = input_d;
        dcb->dcp.p.dvc_offload.src_p   = vcr_globals.proc_id;
        dcb->dcp.p.dvc_offload.src_c   = vcb->port->id;
        dcb->dcp.p.dvc_offload.other_p = HdrDestn(&vcb->dcb->other);
        dcb->dcp.p.dvc_offload.other_c = HdrPort(&vcb->dcb->other);
        HdrBuild(target,vcr_globals.vcr_ctrl_port_id,sizeof(DVC_OFFLOAD)+ctrl_pkt_ovrhd,&dcb->orb.header);
        
        VCR_Enqueue_NBK(&dcb->orb);
      }
      /*}}}*/
      ProcSleep();
    }   
    /*}}}*/
  else
    Exception(UPR_error,_FILE_,__LINE__,"Attempted move on unready channel");

  return (dcb->dcp.p.dvc_doneend.vcb) ;
}
/*}}}*/
/*{{{  PUBLIC void DVC_ReturnChannel(VCB *vcb)*/
PUBLIC void DVC_ReturnChannel(VCB *vcb)
{
  DCB *dcb = vcb->dcb ;
  int priority;

  /*{{{  ensure Hi priority*/
  ProcDesc(&dcb->restart);
  ProcGetPRI(&priority);
  if (priority==PROC_LOW) ProcToHI();
  /*}}}*/
  
  if (dcb==NULL)
    Exception(UPR_error,_FILE_,__LINE__,"Attempted return on static channel");
  if (HdrLength(&dcb->parent)==NULL_HEAD_L)
    Exception(UPR_error,_FILE_,__LINE__,"Tried to Return channel with no parent");
    
  /*{{{  debug Return*/
  #ifdef DVC_DEBUG
  {
    char s[100];
    sprintf(s,"Return [ %d -> %d:%d ]",vcr_globals.proc_id,HdrDestn(&dcb->parent),HdrPort(&dcb->parent));
    Exception(UPR_warning,_FILE_,__LINE__,s);
  }
  #endif
  /*}}}*/

  if (dcb->state == dvc_ready)
  {
    dcb->state = dvc_finding ;
    /*{{{  SEND Offload ; dst_c ;make_way ; src_p ;src_c ; other_p ; other_c*/
    {
      if (dcb->orb.list != InputServiced_p)
        Exception(UPR_error,_FILE_,__LINE__,"ORB in use upon DVC_ReturnChannel") ;
    
      dcb->dcp.tag = dvc_offload ;
      dcb->dcp.p.dvc_offload.dst_c = HdrPort(&dcb->parent) ;
      dcb->dcp.p.dvc_offload.make_way = neuter_d ;
      dcb->dcp.p.dvc_offload.src_p   = vcr_globals.proc_id;
      dcb->dcp.p.dvc_offload.src_c   = vcb->port->id;
      dcb->dcp.p.dvc_offload.other_p = HdrDestn(&vcb->dcb->other);
      dcb->dcp.p.dvc_offload.other_c = HdrPort(&vcb->dcb->other);
      HdrBuild(HdrDestn(&dcb->parent),vcr_globals.vcr_ctrl_port_id,sizeof(DVC_OFFLOAD)+ctrl_pkt_ovrhd,&dcb->orb.header);
      
      VCR_Enqueue_NBK(&dcb->orb);
    }
    /*}}}*/
    ProcSleep();
    DVC_DestroyChannelEnd(vcb);    
  }  
  else
    Exception(UPR_error,_FILE_,__LINE__,"Tried to Return Unready channel");
}
/*}}}*/
