/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Virtual to physical processor mapping function
||@(#)   System : VCR
||@(#) Filename : vmapping.c
||@(#)  Version : 2.1
||@(#)     Date : 6/19/91
\*@(#)====================================================*/
/*}}}*/

#include "stdio.h"
#include "vcr.h"

static char *_FILE_ = __FILE__ ;

/*{{{  PUBLIC int VCR_processor_mapping (int vproc_id)*/
PUBLIC int VCR_processor_mapping (int vproc_id)
{
  VCR_GLOBALS *g = (VCR_GLOBALS *) (* ((GLOBALS **) GLOBAL_PTR))->vcr_gp ;

  if (g->num_nodes == 1)
    return(0) ;
  else
    {
      int d;
      DEVICE *dvc = g->devices ;
    
      for (d=0;d<g->num_devices;d++)
        if (vproc_id==dvc[d].user_id)
          return(dvc[d].physical_id);

      if (vproc_id<0)
        /*{{{  Error device does not exist in network*/
        Exception(UPR_error,_FILE_,__LINE__,"Network does not support device type");
        /*}}}*/

      if (vproc_id==0)
        return(0);
      else
        /*{{{  wrap workers round free processors*/
        {
          int num_workers = g->num_nodes - g->num_devices_wow -1 ;
          int target = 0;
          int gap;
          
          if (num_workers<1)
            Exception(UPR_error,_FILE_,__LINE__,"Insufficient workers in network (too many devices?)");
        
          gap  = ((vproc_id - 1) % num_workers) + 1 ;
          
          while (gap>0)
          {
            target++;
            for (d=0;d<g->num_devices;d++)
              if ((!dvc[d].wrap)&&(target==dvc[d].physical_id))
                break;
            if (d==g->num_devices) gap--;
          }      
          
          return (target) ;
        }
        /*}}}*/
    }
}    
/*}}}*/
