/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : VCR local communications handler
||@(#)   System : VCR
||@(#) Filename : vlocal.c
||@(#)  Version : 2.3
||@(#)     Date : 10/15/92
\*@(#)====================================================*/
/*}}}*/

#include <stdio.h>
#include <stdlib.h>

#include "vcr.h"

static char *_FILE_ = __FILE__ ;

/*#define VCTEST*/

PUBLIC void VCR_LocalHandler (Process *p, LOLB *lolb)
{
  VCR_GLOBALS *g = &vcr_globals ;
  p=p ;

  /*{{{  initialise lolb*/
  lolb->oqb.h = NULL ;
  lolb->oqb.t = NULL ;
  ProcDesc( &(lolb->wdesc) );
  /*}}}*/

  while (TRUE)
  {
    if (lolb->oqb.h == NULL)
      /*{{{  deschedule*/
      {
        lolb->active = FALSE ;
        ProcSleep() ;
      }
      /*}}}*/
    else
      /*{{{  service local packet*/
      {
        ORB *orb = lolb->oqb.h ;
        int port_id = HdrPort (&orb->header) ;
        int size ;
      
        if (orb->bffrlen > UPR_MAX_PKT_SIZE)
        {
          size = UPR_MAX_PKT_SIZE ;
          orb->bffrlen -= size ;
        }
        else
        {
          size = orb->bffrlen ;
          orb->bffrlen = 0 ;
          HdrModLength(size,&orb->header) ;
        }
      
        if (HdrDestn (&orb->header) != g->proc_id)
          Exception(UPR_error,_FILE_,__LINE__,"Internal handler servicing pkt for external destn") ;
      
        /*{{{  packet for here*/
        {
          PORT *port = PortPtr(port_id) ;
          BYTE *buffer ;
        
          #ifdef UPR_DEBUG
          {
            char s[80];
            sprintf(s,"Servicing internal pkt D%0d-P%0d-L%0d",g->proc_id,port_id,size);
            Exception(UPR_warning,_FILE_,__LINE__,s);
          }
          #endif
        
          if (port == NULL)
          { char s[80];
            sprintf(s,"Errant pkt D%0d-P%0d-L%0d",g->proc_id,port_id,size);
            Exception(UPR_warning,_FILE_,__LINE__,s);
            Exception(UPR_error,_FILE_,__LINE__,"Received header on non-allocated port");
          }
          
          /*{{{  sync point for vctest*/
          #ifdef VCTEST
          if (((VCB *) port->state)->buffer != NULL)
          {
            Channel *sync = (Channel *) &(* ((GLOBALS **) GLOBAL_PTR))->bsp_gp ;    
            ChanInInt(sync) ;
          }
          #endif
          /*}}}*/
            
          /*{{{  pre_action*/
          if ((port->space < size) || (port->do_pre))
          {
            if (port->pre_action == (void (*)()) NULL)
              Exception(UPR_error, _FILE_, __LINE__, "No pre-action bound to active port") ;
          
            port->pre_action (port, size) ;
          }  
          
          if (port->space < size)
            Exception(UPR_error, _FILE_, __LINE__, "Out of protocol packet") ;
          /*}}}*/
          /*{{{  read packet*/
          buffer = port->buffer ;
          
          if (size != 0)
          {
            port->buffer += size ;
            port->space  -= size ;
          }
          
          #ifdef VCTEST
          if (((VCB *) port->state)->buffer != NULL)
          {
            Channel *sync = (Channel *) &(* ((GLOBALS **) GLOBAL_PTR))->usr_gp ;    
            ChanInInt(sync) ;
          }
          #endif
          
          if (size != 0)
          {
            if (buffer == NotPointer_p)
              Exception(UPR_error,_FILE_,__LINE__,"Invalid buffer pointer to read packet body into") ;
          
            AsmMove (orb->bffr,buffer,size) ;
          }
          /*}}}*/
          /*{{{  post_action*/
          if ((port->space == 0) || (port->do_post))
          {
            if (port->post_action == (void (*)()) NULL)
              Exception(UPR_error, _FILE_, __LINE__, "No post-action bound to active port") ;
          
            port->post_action (port, size, buffer) ;
          }  
          /*}}}*/
        }
        /*}}}*/
        /*{{{  remove orb from queue*/
        lolb->oqb.h = orb->list ;
        
        if (orb->list == NULL)
          lolb->oqb.t = NULL ;
        /*}}}*/
        /*{{{  complete transaction*/
        if (orb->bffrlen == 0)
        {
          orb->list = InputServiced_p ;
          if (orb->wdesc != NULL)
          {
            ProcAwaken (orb->wdesc) ;
            orb->wdesc = NULL ;
          }
        }
        else
          /*{{{  add orb to tail of local queue*/
          {
            orb->bffr += size ;
          
            orb->list = NULL ;
            
            if (lolb->oqb.h == NULL)
            {  
              lolb->oqb.h = orb ;
              lolb->oqb.t = orb ;
            }
            else
            {
              lolb->oqb.t->list = orb ;
              lolb->oqb.t = orb ;
            }
          }
          /*}}}*/
        /*}}}*/
      }
      /*}}}*/
  }
}
