/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title :  VCR initialisation function
||@(#)   System : VCR
||@(#) Filename : vinit.c
||@(#)  Version : 2.7
\*@(#)====================================================*/
/*}}}*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "vcr.h"
#include "vchan.h"
#include "vcrctrl.h"
#include "vparse.h"
#include "vlocal.h"
#include "vmove.h"

PRIVATE char *_FILE_ = __FILE__ ;

VCR_GLOBALS vcr_globals ;

/*{{{  PRIVATE void init_seed (int *seed, int proc_id, int num_nodes)*/
PRIVATE void init_seed (int *seed, int proc_id, int num_nodes)
{
  int i ;

  *seed = (1+(proc_id+((proc_id*16)+(proc_id*256)))) ;

  for(i=0;i<num_nodes*num_nodes;i++)
     shift_register (seed) ;
}
/*}}}*/

PUBLIC void InitVirtualChannelRouter(int proc_id, int num_nodes, int argc, char *argv[])
{
  /*{{{  install vcr globals if not visible*/
  {
    GLOBALS *g = * ((GLOBALS **) GLOBAL_PTR) ;
   
    if (g->vcr_gp != NULL)
        Exception (UPR_fatal, _FILE_, __LINE__, "VCR globals pointer already occupied") ;
  
    #ifdef UPR_DEBUG
    printf("VCR globals at %x\n", (int) &vcr_globals) ;
    #endif
  
    g->vcr_gp = (void *) &vcr_globals ;
  }  
  /*}}}*/
  /*{{{  initialise vcr globals*/
  vcr_globals.proc_id = proc_id ;
  vcr_globals.num_nodes = num_nodes ;
  
  vcr_globals.gsb     = (void *) *(&(proc_id)-1) ;
  vcr_globals.scdb_stack = (SCDB *) NULL ;
  
  init_seed (&vcr_globals.seed, proc_id, num_nodes) ;
  
  vcr_globals.num_devices = 0;     /* number of devices */
  vcr_globals.num_devices_wow = 0; /* number of devices without wrap*/
  vcr_globals.devices = NULL;
  vcr_globals.err_mode = universal ;
  
  vcr_globals.user_argc = argc-1 ;
  vcr_globals.user_argv = argv+1 ;
      
  SemInit(&vcr_globals.iolock,1) ;
  /*}}}*/
  /*{{{  install exported C functions*/
  vcr_globals.vfunc.VirtualIn  = &VirtualIn ;
  vcr_globals.vfunc.VirtualOut = &VirtualOut ;
  vcr_globals.vfunc.malloc = &malloc ;
  vcr_globals.vfunc.free = &free ;
  vcr_globals.vfunc.Exception = &Exception ;
  
  vcr_globals.vfunc.RPC_PlacedRun = &RPC_PlacedRun ;
  vcr_globals.vfunc.RPC_FindCode  = &RPC_FindCode ;
  vcr_globals.vfunc.RPC_LoadCode  = &RPC_LoadCode ;
  
  vcr_globals.vfunc.DVC_MoveChannel = &DVC_MoveChannel ;
  vcr_globals.vfunc.DVC_ReturnChannel = &DVC_ReturnChannel ;
  vcr_globals.vfunc.DVC_CreateChannelOut = &DVC_CreateChannelOut ;
  vcr_globals.vfunc.DVC_CreateChannelIn  = &DVC_CreateChannelIn ;
  vcr_globals.vfunc.DVC_DestroyChannelEnd  = &DVC_DestroyChannelEnd ;
        
  #ifndef UPR_RD
  vcr_globals.vfunc.HostHook = &HostHook ;
  #else
  vcr_globals.vfunc.HostHook = NULL ;
  #endif
  /*}}}*/
  /*{{{  allocate control port*/
  VCR_CtrlPortAlloc() ;
  
  #ifdef UPR_DEBUG
  printf("VCR Control port has id %d and is allocated at %x\n",
         vcr_globals.vcr_ctrl_port_id, (int) PortPtr(vcr_globals.vcr_ctrl_port_id)) ;
  #endif
  /*}}}*/
  /*{{{  spawn local communications handler*/
  {
    Process *lhp ;
    
    if ((lhp = ProcAlloc(VCR_LocalHandler,0,1,&vcr_globals.lolb))==NULL)
      Exception(UPR_fatal,_FILE_,__LINE__,"ProcAlloc for VCR local handler failed");
  
    ProcRunHigh(lhp);
  }  
  /*}}}*/
  /*{{{  spawn code handler if root*/
  if (proc_id == 0)
  {
    Process *chp ;
    
    if ((chp = ProcAlloc(RPC_CodeHandler,0,1,&vcr_globals.cqb))==NULL)
      Exception(UPR_fatal,_FILE_,__LINE__,"ProcAlloc for VCR code handler failed");
  
    ProcRunHigh(chp);
  }  
  /*}}}*/
  /*{{{  spawn process collector*/
  {
    Process *pc ;
    
    if ((pc = ProcAlloc(VCR_ProcessCollector,0,1,&vcr_globals.pcqb))==NULL)
      Exception(UPR_fatal,_FILE_,__LINE__,"ProcAlloc for VCR process collector");
  
    ProcRunHigh(pc);
  }  
  /*}}}*/
}  
