/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Host hook routine
||@(#)   System : vcr
||@(#) Filename : vhost.c
||@(#)  Version : 2.4
||@(#)     Date : 4/1/92
\*@(#)====================================================*/
/*}}}*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <misc.h>
#include <iocntrl.h>

#include "vcr.h"
#include "vchan.h"

static char *_FILE_ = __FILE__ ;

/*{{{  iserver constants*/
#define SP_MAX_PACKET_DATA_SIZE 510
#define SP_GETKEY   30
#define SP_POLLKEY  31
#define SP_EXIT_TAG 35
#define SP_COMMANDLINE 40
#define SP_SUCCESS   0
#define SP_ERROR   129
/*}}}*/

/*{{{  PUBLIC void HostHook (VCB *fs, VCB *ts, VCB *stopper)*/
PUBLIC void HostHook (VCB *fs, VCB *ts, VCB *stopper)
{
  int length = 0;
  char *buffer ;
  int going = TRUE ;

  if (vcr_globals.proc_id != UPR_root)
    Exception(UPR_error,_FILE_,__LINE__,"Host hook invoked on reduced node") ;

  if ((buffer=malloc(SP_MAX_PACKET_DATA_SIZE)) == NULL)
    Exception (UPR_error,_FILE_,__LINE__,"Out of heap space whilst allocating hosthook buffer") ;
    
  while (going)
  {
    int selected = ProcAlt ((Channel *) ts, (Channel *) stopper, NULL) ;
    
    if (selected == 0)
    {
      VChanIn (ts, &length, 2);
      VChanIn (ts, buffer, length);

      switch (buffer[0])
      {
        case SP_EXIT_TAG :
          /*{{{  terminate server CLEANLY*/
          {
            SemWait (&vcr_globals.iolock) ;
            exit_terminate(EXIT_SUCCESS) ;
          }
          /*}}}*/
        case SP_GETKEY :
          /*{{{  call getkey*/
          {
            buffer[0] = (char) SP_SUCCESS ;
          
            SemWait (&vcr_globals.iolock) ;
            buffer[1] = (char) getkey() ;
            SemSignal(&vcr_globals.iolock) ;
          
            length = 2 ;
            
            VChanOut (fs, &length, 2) ;
            VChanOut (fs, buffer, length);
          
            break ;
          }
          /*}}}*/
        case SP_POLLKEY :
          /*{{{  call pollkey*/
          {
            int c ;
            
            SemWait (&vcr_globals.iolock) ;
            c = pollkey() ;
            SemSignal(&vcr_globals.iolock) ;
          
            if (c < 0)
            {
              buffer[0] = SP_ERROR ;
              length = 1 ;
            }    
            else
            {
              buffer[0] = (char) SP_SUCCESS ;
              buffer[1] = (char) c ;
              length = 2 ;
            }
          
            VChanOut (fs, &length, 2) ;
            VChanOut (fs, buffer, length);
          
            break ;
          }
          /*}}}*/
        case SP_COMMANDLINE :
          /*{{{  provide doctored command-line if requested*/
          {
            int mode = buffer[1] ;
          
            if (mode == 0)
            {
              int p ;
              char *s = &buffer[3] ;
              int len = 0 ;
              *s = 0 ;
              
              for (p=1;p<vcr_globals.user_argc;p++)
              {
                int l = strlen(vcr_globals.user_argv[p])+1 ;
                if (l < (SP_MAX_PACKET_DATA_SIZE-3-len))
                {
                  strcat(s,vcr_globals.user_argv[p]) ;
                  strcat(s, " ") ;
                  len += l ;
                }
                else
                  break ;
              }
          
              if (p == vcr_globals.user_argc)
              {
                buffer[0] = (char) SP_SUCCESS ;
                buffer[1] = *((char *) &len) ;
                buffer[2] = *((char *) &len + 1) ;
                length = len+3 ;
              }
              else
              {
                buffer[0] = (char) SP_ERROR ;
                length = 1 ;
              }
          
              VChanOut (fs, &length, 2) ;
              VChanOut (fs, buffer, length);
              
              break ;
            }
          }
          /*}}}*/
        default :
          /*{{{  issue server transaction*/
          {
            int tag   = (int) (*buffer) ;
            int reply ;
          
            SemWait (&vcr_globals.iolock) ;
            reply = server_transaction (buffer, length, buffer) ;
            SemSignal(&vcr_globals.iolock) ;
          
            if (reply < 0)
            {
              char s[80] ;
              Exception(UPR_warning,_FILE_,__LINE__,"iserver transaction failed") ;
              sprintf(s, "Length of %d, tag of %d, reply length of %d", length, tag, reply) ;
              Exception(UPR_warning,_FILE_,__LINE__,s) ;
            }
            
            else
            {  
              VChanOut (fs, &reply, 2) ;
              VChanOut (fs, buffer, reply) ;
            }
          
            break ;
          }
          /*}}}*/
      }
    }
    else
    {
      BYTE stop ;
      VChanIn (stopper, &stop, 1) ;
      going = FALSE ;
    }
  }
}
/*}}}*/
