/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : SC interface C routines
||@(#)   System : vcr
||@(#) Filename : vcr.c
||@(#)  Version : 2.1
||@(#)     Date : 6/19/91
\*@(#)====================================================*/
/*}}}*/

#include <stdiored.h>
#include <stdlib.h>

#include "vcr.h"

/* These routines must have NO statics of their own */

/*{{{  Virtual channels library stubs*/
/*{{{  PUBLIC void VChanIn      (VCB *c, void *message, int length)*/
PUBLIC void VChanIn      (VCB *c, void *message, int length)
{
  VCR_GLOBALS *g = (VCR_GLOBALS *) (* ((GLOBALS **) GLOBAL_PTR))->vcr_gp ;
  void **gsb = (void **) (&c-1) ;

  if (((int) c & virtual_bit) != 0)
  { 
    *gsb = g->gsb ;
    g->vfunc.VirtualIn ( (VCB *) ((int) c ^ virtual_bit), message, length) ;
  }
  else
    SoftChanIn ( c, message, length) ;
}
/*}}}*/
/*{{{  PUBLIC char VChanInChar  (VCB *c)*/
PUBLIC char VChanInChar  (VCB *c)
{
  char ch ;
  VChanIn (c, &ch, sizeof(char)) ;
  return(ch) ;
}
/*}}}*/
/*{{{  PUBLIC int  VChanInInt   (VCB *c)*/
PUBLIC int  VChanInInt   (VCB *c)
{
  int i ;
  VChanIn (c, &i, sizeof(int)) ;
  return(i) ;
}
/*}}}*/

/*{{{  PUBLIC void VChanOut     (VCB *c, void *message, int length)*/
PUBLIC void VChanOut     (VCB *c, void *message, int length)
{
  VCR_GLOBALS *g = (VCR_GLOBALS *) (* ((GLOBALS **) GLOBAL_PTR))->vcr_gp ;
  void **gsb = (void **) (&c-1) ;

  if (((int) c & virtual_bit) != 0)
  { 
    *gsb = g->gsb ;
    g->vfunc.VirtualOut ( (VCB *) ((int) c ^ virtual_bit), message, length) ;
  }
  else
    SoftChanOut ( c, message, length) ;
}
/*}}}*/
/*{{{  PUBLIC void VChanOutChar (VCB *c, char ch)*/
PUBLIC void VChanOutChar (VCB *c, char ch)
{
  VChanOut (c, &ch, sizeof(char)) ;
}
/*}}}*/
/*{{{  PUBLIC void VChanOutInt  (VCB *c, int i)*/
PUBLIC void VChanOutInt  (VCB *c, int i)
{
  VChanOut (c, &i, sizeof(int)) ;
}
/*}}}*/
/*}}}*/

/*{{{  Miscellaneous system stubs*/
/*{{{  PUBLIC void HostHook(VCB *fs, VCB *ts, VCB *stopper)*/
PUBLIC void HostHook(VCB *fs, VCB *ts, VCB *stopper)
{
  VCR_GLOBALS *g = (VCR_GLOBALS *) (* ((GLOBALS **) GLOBAL_PTR))->vcr_gp ;  
  void **gsb = (void **) (&fs-1) ;

  *gsb = g->gsb ;

  if (g->vfunc.HostHook != NULL)
    g->vfunc.HostHook (fs, ts, stopper) ;
  else
    g->vfunc.Exception (UPR_error,__FILE__,__LINE__,"Host hook invoked on reduced node") ;
}
/*}}}*/
/*{{{  PUBLIC void Exception (int severity, char file[], int line, char msg[])*/
PUBLIC void Exception (int severity, char file[], int line, char msg[])
{
  VCR_GLOBALS *g = (VCR_GLOBALS *) (* ((GLOBALS **) GLOBAL_PTR))->vcr_gp ;  
  void **gsb = (void **) (&severity-1) ;
  *gsb = g->gsb ;
  g->vfunc.Exception (severity, file, line, msg) ;
}
/*}}}*/

/*{{{  PUBLIC void *Malloc (int size)*/
PUBLIC void *Malloc (int size)
{
  VCR_GLOBALS *g = (VCR_GLOBALS *) (* ((GLOBALS **) GLOBAL_PTR))->vcr_gp ;
  void **gsb = (void **) (&size-1) ;

  *gsb = g->gsb ;
  return(g->vfunc.malloc(size)) ;
}
/*}}}*/
/*{{{  PUBLIC void Free (void *pointer)*/
PUBLIC void Free (void *pointer)
{
  VCR_GLOBALS *g = (VCR_GLOBALS *) (* ((GLOBALS **) GLOBAL_PTR))->vcr_gp ;
  void **gsb = (void **) (&pointer-1) ;

  *gsb = g->gsb ;
  g->vfunc.free(pointer) ;
}
/*}}}*/

/*{{{  PUBLIC char *DeviceInfo(int id)*/
PUBLIC char *DeviceInfo(int id)
{
  VCR_GLOBALS *g = (VCR_GLOBALS *) (* ((GLOBALS **) GLOBAL_PTR))->vcr_gp ;
  int i;

  for (i=0;i<g->num_devices;i++)
    if (g->devices[i].user_id==id)
      return (g->devices[i].info);

  return (NULL);
} 
/*}}}*/
/*}}}*/

/*{{{  RPC library stubs*/
/*{{{  PUBLIC SCDB *RPC_FindCode   (char *filename)*/
PUBLIC SCDB *RPC_FindCode   (char *filename)
{
  VCR_GLOBALS *g = (VCR_GLOBALS *) (* ((GLOBALS **) GLOBAL_PTR))->vcr_gp ;
  void **gsb = (void **) (&filename-1) ;

  *gsb = g->gsb ;
  return(g->vfunc.RPC_FindCode (filename)) ;
}
/*}}}*/
/*{{{  PUBLIC SCDB *RPC_LoadCode   (char *filename)*/
PUBLIC SCDB *RPC_LoadCode   (char *filename)
{
  VCR_GLOBALS *g = (VCR_GLOBALS *) (* ((GLOBALS **) GLOBAL_PTR))->vcr_gp ;
  void **gsb = (void **) (&filename-1) ;

  *gsb = g->gsb ;
  return(g->vfunc.RPC_LoadCode (filename)) ;
}
/*}}}*/

/*{{{  PUBLIC void RPC_PlacedRun   (PBLOCK *pblock, char *filename)*/
PUBLIC void RPC_PlacedRun   (PBLOCK *pblock, char *filename)
{
  VCR_GLOBALS *g = (VCR_GLOBALS *) (* ((GLOBALS **) GLOBAL_PTR))->vcr_gp ;
  void **gsb = (void **) (&pblock-1) ;

  *gsb = g->gsb ;
  g->vfunc.RPC_PlacedRun (pblock, filename) ;
}
/*}}}*/

/* Remaining calls in vcommon.c do not require stub calls */
/*}}}*/

/*{{{  Low-level stubs to DVC routines*/
/*{{{  PUBLIC VCB *DVC_MoveChannel (int target, VCB *c)*/
PUBLIC VCB *DVC_MoveChannel (int target, VCB *c)
{
  VCR_GLOBALS *g = (VCR_GLOBALS *) (* ((GLOBALS **) GLOBAL_PTR))->vcr_gp ;
  void **gsb = (void **) (&target-1) ;
  VCB *other ;

  if ((int) c & virtual_bit == 0)
    Exception (UPR_error,__FILE__,__LINE__,"Cannot move soft channel") ;
  
  *gsb = g->gsb ;
  other = g->vfunc.DVC_MoveChannel (VCR_processor_mapping(target), (VCB *) ((int) c ^ virtual_bit)) ;
  return ((VCB *)((int) other ^ virtual_bit)) ;
}
/*}}}*/
/*{{{  PUBLIC void DVC_ReturnChannel   (VCB *c)*/
PUBLIC void DVC_ReturnChannel   (VCB *c)
{
  VCR_GLOBALS *g = (VCR_GLOBALS *) (* ((GLOBALS **) GLOBAL_PTR))->vcr_gp ;
  void **gsb = (void **) (&c-1) ;

  if ((int) c & virtual_bit == 0)
    Exception (UPR_error,__FILE__,__LINE__,"Cannot return soft channel") ;
  
  *gsb = g->gsb ;
  g->vfunc.DVC_ReturnChannel((VCB *) ((int) c ^ virtual_bit));
}   
/*}}}*/
/*{{{  PUBLIC void DVC_CreateChannelOut (VCB **local_out, VCB **remote_in, int remote)*/
PUBLIC void DVC_CreateChannelOut (VCB **local_out, VCB **remote_in, int remote)
{
  VCR_GLOBALS *g = (VCR_GLOBALS *) (* ((GLOBALS **) GLOBAL_PTR))->vcr_gp ;
  void **gsb = (void **) (&local_out-1) ;

  *gsb = g->gsb ;
  g->vfunc.DVC_CreateChannelOut(local_out,remote_in, VCR_processor_mapping(remote)) ;
  *local_out = (VCB *)((int) *local_out ^ virtual_bit) ;
  *remote_in = (VCB *)((int) *remote_in ^ virtual_bit) ;
}

/*}}}*/
/*{{{  PUBLIC void DVC_CreateChannelIn  (VCB **local_in, VCB **remote_out, int remote)*/
PUBLIC void DVC_CreateChannelIn  (VCB **local_in, VCB **remote_out, int remote)
{
  VCR_GLOBALS *g = (VCR_GLOBALS *) (* ((GLOBALS **) GLOBAL_PTR))->vcr_gp ;
  void **gsb = (void **) (&local_in-1) ;

  *gsb = g->gsb ;
  g->vfunc.DVC_CreateChannelIn(local_in, remote_out, VCR_processor_mapping(remote)) ;
  *local_in = (VCB *)((int) *local_in ^ virtual_bit) ;
  *remote_out = (VCB *)((int) *remote_out ^ virtual_bit) ;
}
/*}}}*/
/*{{{  PUBLIC void DVC_DestroyChannelEnd(VCB *c)*/
PUBLIC void DVC_DestroyChannelEnd(VCB *c)
{
  VCR_GLOBALS *g = (VCR_GLOBALS *) (* ((GLOBALS **) GLOBAL_PTR))->vcr_gp ;
  void **gsb = (void **) (&c-1) ;

  if ((int) c & virtual_bit == 0)
    Exception (UPR_error,__FILE__,__LINE__,"Cannot destroy soft channel") ;
  
  *gsb = g->gsb ;
  g->vfunc.DVC_DestroyChannelEnd((VCB *) ((int) c ^ virtual_bit)) ;
}
/*}}}*/
/*}}}*/

