/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : PUMA ESPRIT P2701
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : PC command tool
||@(#)   System : 
||@(#) Filename : vcrtool.c
||@(#)  Version : 1.1
||@(#)     Date : 5/28/91
\*@(#)====================================================*/
/*}}}*/

#include "stdio.h"
#include "string.h"
#include "ctype.h"

#ifndef command
#define command "echo no command"
#endif

int main(argc, argv)
int argc ;
char *argv[] ;
{
  char sin[200];
  char sout[200];
  char *env;
  char *gotenv;
  char tmp;
  int i,j, param;

  param = 1;
  strcpy(sin,command);
  
  /*{{{  convert ! to spaces and count parameters*/
  for (i=0;sin[i]!=0;i++)
    if (sin[i]=='!')
      sin[i]=' ';     
    else if (sin[i]=='%')
      param++;
  /*}}}*/
  /*{{{  check sufficient parameters*/
  if (param>argc)
  {
    fprintf(stderr,"Too few parameters\n");
    return(-1);
  }
  /*}}}*/
  /*{{{  add parameters to command line*/
  for (;param<argc;param++)
  {
    strcat(sin," ");
    strcat(sin,argv[param]);
  }
  /*}}}*/
  /*{{{  generate command line with appropriate substitutions*/
  param = 1;
  j=0;
  for (i=0;sin[i]!=0;i++)
    if (sin[i]=='$')
      /*{{{  insert environment variable*/
      {
        env=&sin[++i];
        while (isalnum(sin[i])) i++;
        tmp=sin[i];
        sin[i] = 0;
        gotenv = (char *) getenv(env);
        if (gotenv==NULL)
        {
          fprintf(stderr,"No environment variable %s\n",env);
          return(-1);
        }
        sin[i--]=tmp;
        while (*gotenv!=0)
          sout[j++] = *(gotenv++);
      }
      /*}}}*/
    else if (sin[i]=='%')
      /*{{{  insert parameter*/
      {
        char *arg;
        arg = argv[param++];
        while (*arg!=0)
          sout[j++] = *(arg++);
      }
      /*}}}*/
    else
      sout[j++]= sin[i] ;
  sout[j]=0;
  /*}}}*/
  if (j>127)
    /*{{{  command too long*/
    {
      fprintf(stderr,"Command line too long (%d characters)\n",j);
      return(-1);
    }
    /*}}}*/
  else
    return(system(sout)) ;
}
