/*{{{  File banner*/
/*@(#)=====================================================*\
||@(#)  Project : GPMIMD ESPRIT P5404
||@(#)  Authors : Mark Debbage and Mark Hill
||@(#)            University of Southampton
||  
||@(#)    Title : Mesh wiring diagram generator
||@(#)   System : VCR
||@(#) Filename : mesh2map.c
||@(#)  Version : 1.3
||@(#)     Date : 7/16/92
\*@(#)====================================================*/
/*}}}*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define north 0
#define east  1
#define west  2
#define south 3

typedef enum {grid,torus,ring} MODE ;

static char *TORUS ="torus" ;
static char *GRID  ="grid" ;
static char *RING  ="ring" ;

/*{{{  int charcasecmp (char c1, char c2)*/
int charcasecmp (char c1, char c2)
{
  if (isalpha(c1)) c1 = tolower(c1) ;
  if (isalpha(c2)) c2 = tolower(c2) ;

  if (c1<c2)
    return(-1) ;
  else if (c1>c2)
    return(1) ;
  else
    return(0) ;
}   
   
/*}}}*/
/*{{{  int strncasecmp (char *s1, char *s2, int n)*/
int strncasecmp (char *s1, char *s2, int n)
{
  while (*s1 && *s2 && n>1)
  {
    int cmp = charcasecmp(*s1,*s2) ;

    if (cmp != 0) return(cmp) ;

    s1++ ;
    s2++ ;
    n-- ;
  }

  return(charcasecmp(*s1,*s2)) ;
}
/*}}}*/

void connect (int p1, int l1, int p2, int l2)
{
  printf("Connect processor %d link %d to processor %d link %d\n",p1,l1,p2,l2) ;
}  

int main(int argc, char **argv)
{
  MODE mode ;
  int x, y, nx, ny ;
  
  /*{{{  skip path*/
  {
    int i=0;
    while (argv[0][i]!='\0')
      if (argv[0][i]=='/' || argv[0][i]=='\\')
      {
        argv[0] = &argv[0][i+1];
        i=0;
      }
      else
        i++;
  }      
  /*}}}*/
  if (strncasecmp(argv[0],TORUS,strlen(TORUS))==0)
    mode=torus ;
  else if (strncasecmp(argv[0],GRID,strlen(GRID))==0)
    mode=grid ;
  else if (strncasecmp(argv[0],RING,strlen(RING))==0)
    mode=ring ;
  else
  {
    printf("Unknown program name %s\n",argv[0]) ;
    return(-1) ;
  }

  if (argc!=3)
  {
    printf("Usage: %s <nx> <ny>\n",argv[0]) ;
    return(-1) ;
  }

  nx = atoi(argv[1]) ;
  ny = atoi(argv[2]) ;
    
  printf("Wiring Diagram\n") ;
  
  for (y=0;y<ny;y++)
  {
    for (x=0;x<nx-1;x++)
      connect(y*nx+x,east,y*nx+x+1,west) ;
    
    if (mode==torus || mode==ring)
      connect(y*nx+x,east,y*nx,west) ;
  }
  
  for (x=0;x<nx;x++)
  {
    for (y=0;y<ny-1;y++)
      connect(y*nx+x,south,y*nx+nx+x,north) ;
    
    if (mode==torus)
      connect(y*nx+x,south,x,north) ;
  }
}
